/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.gradle.process.internal.ExecHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessBuilderFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessBuilderFactory.class);

    public ProcessBuilder createProcessBuilder(ExecHandle execHandle) {
        ArrayList<String> commandWithArguments = new ArrayList<String>();
        String command = execHandle.getCommand();
        commandWithArguments.add(command);
        List<String> arguments = execHandle.getArguments();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("creating process builder for {}", (Object)execHandle);
            LOGGER.debug("in directory {}", (Object)execHandle.getDirectory());
            int argumentIndex = 0;
            for (String argument : arguments) {
                LOGGER.debug("with argument#{} = {}", (Object)argumentIndex, (Object)argument);
                ++argumentIndex;
            }
        }
        commandWithArguments.addAll(arguments);
        ProcessBuilder processBuilder = new ProcessBuilder(commandWithArguments);
        processBuilder.directory(execHandle.getDirectory());
        Map<String, String> environment = processBuilder.environment();
        environment.clear();
        environment.putAll(execHandle.getEnvironment());
        return processBuilder;
    }
}

