/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.IdentityFileResolver;
import org.gradle.process.ExecSpec;
import org.gradle.process.internal.AbstractExecHandleBuilder;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecHandleBuilder
extends AbstractExecHandleBuilder
implements ExecSpec {
    private final List<Object> arguments = new ArrayList<Object>();

    public ExecHandleBuilder() {
        super(new IdentityFileResolver());
    }

    public ExecHandleBuilder(FileResolver fileResolver) {
        super(fileResolver);
    }

    @Override
    public ExecHandleBuilder commandLine(Object ... arguments) {
        this.commandLine(Arrays.asList(arguments));
        return this;
    }

    @Override
    public ExecSpec commandLine(Iterable<?> args) {
        List argsList = GUtil.addLists(args);
        this.executable(argsList.get(0));
        this.setArgs((Iterable)argsList.subList(1, argsList.size()));
        return this;
    }

    @Override
    public void setCommandLine(Object ... args) {
        this.commandLine(args);
    }

    @Override
    public void setCommandLine(Iterable<?> args) {
        this.commandLine(args);
    }

    @Override
    public ExecHandleBuilder args(Object ... args) {
        if (args == null) {
            throw new IllegalArgumentException("args == null!");
        }
        this.arguments.addAll(Arrays.asList(args));
        return this;
    }

    @Override
    public ExecSpec args(Iterable<?> args) {
        GUtil.addToCollection(this.arguments, args);
        return this;
    }

    @Override
    public ExecHandleBuilder setArgs(Iterable<?> arguments) {
        this.arguments.clear();
        GUtil.addToCollection(this.arguments, arguments);
        return this;
    }

    @Override
    public List<String> getArgs() {
        ArrayList<String> args = new ArrayList<String>();
        for (Object argument : this.arguments) {
            args.add(argument.toString());
        }
        return args;
    }

    @Override
    public List<String> getAllArguments() {
        return this.getArgs();
    }

    @Override
    public ExecHandleBuilder setIgnoreExitValue(boolean ignoreExitValue) {
        super.setIgnoreExitValue(ignoreExitValue);
        return this;
    }
}

