/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal;

import java.io.ByteArrayInputStream;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.gradle.api.internal.ClassPathRegistry;
import org.gradle.api.internal.Factory;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.logging.LogLevel;
import org.gradle.messaging.remote.MessagingServer;
import org.gradle.process.internal.DefaultWorkerProcess;
import org.gradle.process.internal.ExecHandle;
import org.gradle.process.internal.JavaExecHandleBuilder;
import org.gradle.process.internal.WorkerProcess;
import org.gradle.process.internal.WorkerProcessBuilder;
import org.gradle.process.internal.child.ApplicationClassesInIsolatedClassLoaderWorkerFactory;
import org.gradle.process.internal.child.ApplicationClassesInSystemClassLoaderWorkerFactory;
import org.gradle.process.internal.child.WorkerFactory;
import org.gradle.process.internal.launcher.GradleWorkerMain;
import org.gradle.util.ClasspathUtil;
import org.gradle.util.GUtil;
import org.gradle.util.IdGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultWorkerProcessFactory
implements Factory<WorkerProcessBuilder> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultWorkerProcessFactory.class);
    private final LogLevel workerLogLevel;
    private final MessagingServer server;
    private final ClassPathRegistry classPathRegistry;
    private final FileResolver resolver;
    private final IdGenerator<?> idGenerator;

    public DefaultWorkerProcessFactory(LogLevel workerLogLevel, MessagingServer server, ClassPathRegistry classPathRegistry, FileResolver resolver, IdGenerator<?> idGenerator) {
        this.workerLogLevel = workerLogLevel;
        this.server = server;
        this.classPathRegistry = classPathRegistry;
        this.resolver = resolver;
        this.idGenerator = idGenerator;
    }

    @Override
    public WorkerProcessBuilder create() {
        return new DefaultWorkerProcessBuilder();
    }

    private class DefaultWorkerProcessBuilder
    extends WorkerProcessBuilder {
        public DefaultWorkerProcessBuilder() {
            super(DefaultWorkerProcessFactory.this.resolver);
            this.setLogLevel(DefaultWorkerProcessFactory.this.workerLogLevel);
            this.getJavaCommand().setMain(GradleWorkerMain.class.getName());
        }

        public WorkerProcess build() {
            if (this.getWorker() == null) {
                throw new IllegalStateException("No worker action specified for this worker process.");
            }
            DefaultWorkerProcess workerProcess = new DefaultWorkerProcess(120, TimeUnit.SECONDS);
            URI localAddress = DefaultWorkerProcessFactory.this.server.accept(workerProcess.getConnectAction());
            List<URL> implementationClassPath = ClasspathUtil.getClasspath(this.getWorker().getClass().getClassLoader());
            Object id = DefaultWorkerProcessFactory.this.idGenerator.generateId();
            String displayName = String.format("Gradle Worker %s", id);
            WorkerFactory workerFactory = this.isLoadApplicationInSystemClassLoader() ? new ApplicationClassesInSystemClassLoaderWorkerFactory(id, displayName, this, implementationClassPath, localAddress, DefaultWorkerProcessFactory.this.classPathRegistry) : new ApplicationClassesInIsolatedClassLoaderWorkerFactory(id, displayName, this, implementationClassPath, localAddress, DefaultWorkerProcessFactory.this.classPathRegistry);
            Callable<?> workerMain = workerFactory.create();
            byte[] config = GUtil.serialize(workerMain);
            LOGGER.debug("Creating {}", (Object)displayName);
            LOGGER.debug("Using application classpath {}", this.getApplicationClasspath());
            LOGGER.debug("Using implementation classpath {}", implementationClassPath);
            JavaExecHandleBuilder javaCommand = this.getJavaCommand();
            javaCommand.classpath(workerFactory.getSystemClasspath());
            javaCommand.setStandardInput(new ByteArrayInputStream(config));
            javaCommand.setDisplayName(displayName);
            ExecHandle execHandle = javaCommand.build();
            workerProcess.setExecHandle(execHandle);
            return workerProcess;
        }
    }
}

