/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.gradle.api.GradleException;
import org.gradle.messaging.remote.internal.ConnectException;
import org.gradle.messaging.remote.internal.Connection;
import org.gradle.messaging.remote.internal.OutgoingConnector;
import org.gradle.messaging.remote.internal.SocketConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TcpOutgoingConnector
implements OutgoingConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(TcpOutgoingConnector.class);
    private ClassLoader classLoader;

    public TcpOutgoingConnector(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public <T> Connection<T> connect(URI destinationUri) {
        if (!destinationUri.getScheme().equals("tcp") || destinationUri.getHost() == null || !destinationUri.getHost().equals("localhost")) {
            throw new IllegalArgumentException(String.format("Cannot create connection to destination URI '%s'.", destinationUri));
        }
        List<InetAddress> loopBackAddresses = TcpOutgoingConnector.findLocalAddresses();
        try {
            SocketException lastFailure = null;
            for (InetAddress address : loopBackAddresses) {
                SocketChannel socketChannel;
                LOGGER.debug("Trying to connect to address {}.", (Object)address);
                try {
                    socketChannel = SocketChannel.open(new InetSocketAddress(address, destinationUri.getPort()));
                }
                catch (SocketException e) {
                    LOGGER.debug("Cannot connect to address {}, skipping.", (Object)address);
                    lastFailure = e;
                    continue;
                }
                LOGGER.debug("Connected to address {}.", (Object)address);
                URI localAddress = new URI(String.format("tcp://localhost:%d", socketChannel.socket().getLocalPort()));
                return new SocketConnection(socketChannel, localAddress, destinationUri, this.classLoader);
            }
            throw lastFailure;
        }
        catch (java.net.ConnectException e) {
            throw new ConnectException(String.format("Could not connect to server %s. Tried addresses: %s.", destinationUri, loopBackAddresses), e);
        }
        catch (Exception e) {
            throw new GradleException(String.format("Could not connect to server %s. Tried addresses: %s.", destinationUri, loopBackAddresses), e);
        }
    }

    static List<InetAddress> findLocalAddresses() {
        try {
            ArrayList<InetAddress> addresses = new ArrayList<InetAddress>();
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface networkInterface = interfaces.nextElement();
                Enumeration<InetAddress> candidates = networkInterface.getInetAddresses();
                while (candidates.hasMoreElements()) {
                    InetAddress inetAddress = candidates.nextElement();
                    if (!inetAddress.isLoopbackAddress()) continue;
                    addresses.add(inetAddress);
                }
            }
            if (addresses.isEmpty()) {
                addresses.add(InetAddress.getByName(null));
            }
            LOGGER.debug("Found loop-back addresses: {}.", addresses);
            return addresses;
        }
        catch (Exception e) {
            throw new GradleException("Could not determine the local loop-back addresses.", e);
        }
    }
}

