/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal;

import java.net.URI;
import org.gradle.api.Action;
import org.gradle.messaging.concurrent.CompositeStoppable;
import org.gradle.messaging.concurrent.DefaultExecutorFactory;
import org.gradle.messaging.remote.ConnectEvent;
import org.gradle.messaging.remote.MessagingServer;
import org.gradle.messaging.remote.ObjectConnection;
import org.gradle.messaging.remote.internal.Connection;
import org.gradle.messaging.remote.internal.DefaultMessagingServer;
import org.gradle.messaging.remote.internal.DefaultMultiChannelConnector;
import org.gradle.messaging.remote.internal.Message;
import org.gradle.messaging.remote.internal.OutgoingConnector;
import org.gradle.messaging.remote.internal.TcpIncomingConnector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TcpMessagingServer
implements MessagingServer {
    private final TcpIncomingConnector incomingConnector;
    private final DefaultMultiChannelConnector connector;
    private final DefaultMessagingServer server;
    private final DefaultExecutorFactory executorFactory = new DefaultExecutorFactory();

    public TcpMessagingServer(ClassLoader messageClassLoader) {
        this.incomingConnector = new TcpIncomingConnector(this.executorFactory, messageClassLoader);
        this.connector = new DefaultMultiChannelConnector(new NoOpOutgoingConnector(), this.incomingConnector, this.executorFactory);
        this.server = new DefaultMessagingServer(this.connector, messageClassLoader);
    }

    @Override
    public URI accept(Action<ConnectEvent<ObjectConnection>> action) {
        return this.server.accept(action);
    }

    @Override
    public void stop() {
        this.incomingConnector.requestStop();
        new CompositeStoppable(this.server, this.connector, this.incomingConnector, this.executorFactory).stop();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NoOpOutgoingConnector
    implements OutgoingConnector {
        private NoOpOutgoingConnector() {
        }

        public Connection<Message> connect(URI destinationUri) {
            throw new UnsupportedOperationException();
        }
    }
}

