/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import org.gradle.api.GradleException;
import org.gradle.api.UncheckedIOException;
import org.gradle.messaging.concurrent.CompositeStoppable;
import org.gradle.messaging.remote.internal.Connection;
import org.gradle.messaging.remote.internal.Message;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocketConnection<T>
implements Connection<T> {
    private final SocketChannel socket;
    private final Object localAddress;
    private final Object remoteAddress;
    private final ClassLoader classLoader;
    private final InputStream instr;
    private final OutputStream outstr;

    public SocketConnection(SocketChannel socket, Object localAddress, Object remoteAddress, ClassLoader classLoader) {
        this.socket = socket;
        this.localAddress = localAddress;
        this.remoteAddress = remoteAddress;
        this.classLoader = classLoader;
        try {
            socket.configureBlocking(false);
            this.outstr = new SocketOutputStream(socket);
            this.instr = new SocketInputStream(socket);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String toString() {
        return String.format("socket connection at %s with %s", this.localAddress, this.remoteAddress);
    }

    @Override
    public T receive() {
        try {
            return (T)Message.receive(this.instr, this.classLoader);
        }
        catch (Exception e) {
            if (this.isEndOfStream(e)) {
                return null;
            }
            throw new GradleException(String.format("Could not read message from '%s'.", this.remoteAddress), e);
        }
    }

    private boolean isEndOfStream(Exception e) {
        if (e instanceof EOFException) {
            return true;
        }
        return e instanceof IOException && e.getMessage() != null && e.getMessage().equals("An existing connection was forcibly closed by the remote host");
    }

    @Override
    public void dispatch(T message) {
        try {
            Message.send(message, this.outstr);
            this.outstr.flush();
        }
        catch (Exception e) {
            throw new GradleException(String.format("Could not write message to '%s'.", this.remoteAddress), e);
        }
    }

    @Override
    public void requestStop() {
        new CompositeStoppable(this.instr).stop();
    }

    @Override
    public void stop() {
        new CompositeStoppable(this.instr, this.outstr, this.socket).stop();
    }

    private static class SocketOutputStream
    extends OutputStream {
        private final Selector selector;
        private final SocketChannel socket;
        private final ByteBuffer buffer;
        private final byte[] writeBuffer = new byte[1];

        public SocketOutputStream(SocketChannel socket) throws IOException {
            this.socket = socket;
            this.selector = Selector.open();
            socket.register(this.selector, 4);
            this.buffer = ByteBuffer.allocateDirect(4096);
        }

        public void write(int b) throws IOException {
            this.writeBuffer[0] = (byte)b;
            this.write(this.writeBuffer);
        }

        public void write(byte[] src, int offset, int max) throws IOException {
            int remaining = max;
            int currentPos = offset;
            while (remaining > 0) {
                int count = Math.min(remaining, this.buffer.remaining());
                if (count > 0) {
                    this.buffer.put(src, currentPos, count);
                    remaining -= count;
                    currentPos += count;
                }
                if (this.buffer.remaining() != 0) continue;
                this.flush();
            }
        }

        public void flush() throws IOException {
            this.buffer.flip();
            while (this.buffer.remaining() > 0) {
                this.selector.select();
                if (!this.selector.isOpen()) {
                    throw new EOFException();
                }
                this.socket.write(this.buffer);
            }
            this.buffer.clear();
        }

        public void close() throws IOException {
            this.selector.close();
        }
    }

    private static class SocketInputStream
    extends InputStream {
        private final Selector selector;
        private final ByteBuffer buffer;
        private final SocketChannel socket;
        private final byte[] readBuffer = new byte[1];

        public SocketInputStream(SocketChannel socket) throws IOException {
            this.socket = socket;
            this.selector = Selector.open();
            socket.register(this.selector, 1);
            this.buffer = ByteBuffer.allocateDirect(4096);
            this.buffer.limit(0);
        }

        public int read() throws IOException {
            int nread = this.read(this.readBuffer, 0, 1);
            if (nread <= 0) {
                return nread;
            }
            return this.readBuffer[0];
        }

        public int read(byte[] dest, int offset, int max) throws IOException {
            if (max == 0) {
                return 0;
            }
            if (this.buffer.remaining() == 0) {
                this.selector.select();
                if (!this.selector.isOpen()) {
                    return -1;
                }
                this.buffer.clear();
                int nread = this.socket.read(this.buffer);
                this.buffer.flip();
                if (nread < 0) {
                    return -1;
                }
            }
            int count = Math.min(this.buffer.remaining(), max);
            this.buffer.get(dest, offset, count);
            return count;
        }

        public void close() throws IOException {
            this.selector.close();
        }
    }
}

