/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.gradle.messaging.remote.internal.Message;
import org.gradle.util.UncheckedException;

public class MethodMetaInfo
extends Message {
    private final Type type;
    private final String methodName;
    private final Type[] paramTypes;
    private final Object key;

    public MethodMetaInfo(Object key, Method method) {
        this.key = key;
        this.type = new Type(method.getDeclaringClass());
        this.methodName = method.getName();
        this.paramTypes = new Type[method.getParameterTypes().length];
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            Class<?> paramType = method.getParameterTypes()[i];
            this.paramTypes[i] = new Type(paramType);
        }
    }

    public Object getKey() {
        return this.key;
    }

    public Method findMethod(ClassLoader classLoader) {
        try {
            Class<?> declaringClass = this.type.load(classLoader);
            Class[] paramTypes = new Class[this.paramTypes.length];
            for (int i = 0; i < this.paramTypes.length; ++i) {
                Type paramType = this.paramTypes[i];
                paramTypes[i] = paramType.load(classLoader);
            }
            return declaringClass.getMethod(this.methodName, paramTypes);
        }
        catch (Exception e) {
            throw UncheckedException.asUncheckedException(e);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        MethodMetaInfo other = (MethodMetaInfo)obj;
        if (!this.key.equals(other.key)) {
            return false;
        }
        if (!this.type.equals(other.type)) {
            return false;
        }
        if (!this.methodName.equals(other.methodName)) {
            return false;
        }
        return Arrays.equals(this.paramTypes, other.paramTypes);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Type
    implements Serializable {
        private String typeName;
        private Class<?> type;

        public Type(Class<?> type) {
            this.typeName = type.getName();
            if (type.isPrimitive()) {
                this.type = type;
            }
        }

        Class<?> load(ClassLoader classLoader) throws ClassNotFoundException {
            if (this.type != null) {
                return this.type;
            }
            return classLoader.loadClass(this.typeName);
        }

        public boolean equals(Object obj) {
            return ((Type)obj).typeName.equals(this.typeName);
        }

        public int hashCode() {
            return this.typeName.hashCode();
        }
    }
}

