/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import org.gradle.messaging.remote.internal.PlaceholderException;
import org.gradle.util.ClassLoaderObjectInputStream;
import org.gradle.util.UncheckedException;

public abstract class Message
implements Serializable {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void send(Object message, OutputStream outputSteam) throws IOException {
        ExceptionReplacingObjectOutputStream oos = new ExceptionReplacingObjectOutputStream(outputSteam);
        try {
            oos.writeObject(message);
        }
        finally {
            oos.flush();
        }
    }

    public static Object receive(InputStream inputSteam, ClassLoader classLoader) throws IOException, ClassNotFoundException {
        ExceptionReplacingObjectInputStream ois = new ExceptionReplacingObjectInputStream(inputSteam, classLoader);
        return ois.readObject();
    }

    private static class ExceptionReplacingObjectInputStream
    extends ClassLoaderObjectInputStream {
        public ExceptionReplacingObjectInputStream(InputStream inputSteam, ClassLoader classLoader) throws IOException {
            super(inputSteam, classLoader);
            this.enableResolveObject(true);
        }

        protected Object resolveObject(Object obj) throws IOException {
            if (obj instanceof TopLevelExceptionPlaceholder) {
                return ((ExceptionPlaceholder)obj).read(this.getClassLoader());
            }
            return obj;
        }
    }

    private static class ExceptionReplacingObjectOutputStream
    extends ObjectOutputStream {
        public ExceptionReplacingObjectOutputStream(OutputStream outputSteam) throws IOException {
            super(outputSteam);
            this.enableReplaceObject(true);
        }

        protected Object replaceObject(Object obj) throws IOException {
            if (obj instanceof Throwable) {
                return new TopLevelExceptionPlaceholder((Throwable)obj);
            }
            return obj;
        }
    }

    private static class TopLevelExceptionPlaceholder
    extends ExceptionPlaceholder {
        private TopLevelExceptionPlaceholder(Throwable throwable) throws IOException {
            super(throwable);
        }
    }

    private static class CausePlaceholder
    implements Serializable {
        private CausePlaceholder() {
        }
    }

    private static class ExceptionPlaceholder
    implements Serializable {
        private byte[] serializedException;
        private String type;
        private String message;
        private ExceptionPlaceholder cause;
        private StackTraceElement[] stackTrace;

        public ExceptionPlaceholder(final Throwable throwable) throws IOException {
            ByteArrayOutputStream outstr = new ByteArrayOutputStream();
            ExceptionReplacingObjectOutputStream oos = new ExceptionReplacingObjectOutputStream(outstr){

                protected Object replaceObject(Object obj) throws IOException {
                    if (obj == throwable) {
                        return throwable;
                    }
                    if (obj == throwable.getCause()) {
                        return new CausePlaceholder();
                    }
                    return super.replaceObject(obj);
                }
            };
            try {
                oos.writeObject(throwable);
                oos.close();
                this.serializedException = outstr.toByteArray();
            }
            catch (NotSerializableException e) {
                // empty catch block
            }
            this.type = throwable.getClass().getName();
            this.message = throwable.getMessage();
            if (throwable.getCause() != null) {
                this.cause = new ExceptionPlaceholder(throwable.getCause());
            }
            this.stackTrace = throwable.getStackTrace();
        }

        public Throwable read(ClassLoader classLoader) throws IOException {
            final Throwable causeThrowable = this.getCause(classLoader);
            Throwable throwable = null;
            if (this.serializedException != null) {
                try {
                    ExceptionReplacingObjectInputStream ois = new ExceptionReplacingObjectInputStream(new ByteArrayInputStream(this.serializedException), classLoader){

                        protected Object resolveObject(Object obj) throws IOException {
                            if (obj instanceof CausePlaceholder) {
                                return causeThrowable;
                            }
                            return super.resolveObject(obj);
                        }
                    };
                    throwable = (Throwable)ois.readObject();
                }
                catch (ClassNotFoundException e) {
                }
                catch (InvalidClassException e) {
                    try {
                        Constructor<?> constructor = classLoader.loadClass(this.type).getConstructor(String.class);
                        throwable = (Throwable)constructor.newInstance(this.message);
                        throwable.initCause(causeThrowable);
                        throwable.setStackTrace(this.stackTrace);
                    }
                    catch (ClassNotFoundException e1) {
                    }
                    catch (NoSuchMethodException e1) {
                    }
                    catch (Throwable t) {
                        throw UncheckedException.asUncheckedException(t);
                    }
                }
            }
            if (throwable == null) {
                throwable = new PlaceholderException(String.format("%s: %s", this.type, this.message), causeThrowable);
                throwable.setStackTrace(this.stackTrace);
            }
            return throwable;
        }

        private Throwable getCause(ClassLoader classLoader) throws IOException {
            return this.cause != null ? this.cause.read(classLoader) : null;
        }
    }
}

