/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.gradle.messaging.dispatch.Dispatch;
import org.gradle.messaging.dispatch.MethodInvocation;
import org.gradle.messaging.dispatch.ReflectionDispatch;
import org.gradle.messaging.remote.internal.MethodInvocationUnmarshallingDispatch;
import org.gradle.messaging.remote.internal.MultiChannelConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncomingMethodInvocationHandler {
    private final ClassLoader classLoader;
    private final MultiChannelConnection<Object> connection;
    private final Set<Class<?>> classes = new CopyOnWriteArraySet();

    public IncomingMethodInvocationHandler(ClassLoader classLoader, MultiChannelConnection<Object> connection) {
        this.classLoader = classLoader;
        this.connection = connection;
    }

    public <T> void addIncoming(Class<T> type, T instance) {
        this.addIncoming((Class<?>)type, new ReflectionDispatch(instance));
    }

    public void addIncoming(Class<?> type, Dispatch<? super MethodInvocation> dispatch) {
        HashSet incomingTypes = new HashSet();
        this.addInterfaces(type, incomingTypes);
        for (Class clazz : incomingTypes) {
            if (!this.classes.add(clazz)) {
                throw new IllegalArgumentException(String.format("A handler has already been added for type '%s'.", clazz.getName()));
            }
            this.connection.addIncomingChannel(clazz.getName(), new MethodInvocationUnmarshallingDispatch(dispatch, this.classLoader));
        }
    }

    private void addInterfaces(Class<?> type, Set<Class<?>> superInterfaces) {
        superInterfaces.add(type);
        for (Class<?> superType : type.getInterfaces()) {
            this.addInterfaces(superType, superInterfaces);
        }
    }
}

