/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.messaging.concurrent.Stoppable;
import org.gradle.messaging.dispatch.Dispatch;
import org.gradle.messaging.remote.internal.EndOfStreamEvent;
import org.gradle.util.UncheckedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndOfStreamFilter
implements Dispatch<Object>,
Stoppable {
    private final Dispatch<Object> dispatch;
    private final Runnable endOfStreamAction;
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private boolean endOfStreamReached;

    public EndOfStreamFilter(Dispatch<Object> dispatch, Runnable endOfStreamAction) {
        this.dispatch = dispatch;
        this.endOfStreamAction = endOfStreamAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatch(Object message) {
        this.lock.lock();
        try {
            if (this.endOfStreamReached) {
                throw new IllegalStateException(String.format("Cannot dispatch message %s, as this dispatch has been stopped.", message));
            }
            if (message instanceof EndOfStreamEvent) {
                this.endOfStreamReached = true;
                this.condition.signalAll();
                this.endOfStreamAction.run();
                return;
            }
        }
        finally {
            this.lock.unlock();
        }
        this.dispatch.dispatch(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void stop() {
        this.lock.lock();
        try {
            while (!this.endOfStreamReached) {
                try {
                    this.condition.await();
                }
                catch (InterruptedException e) {
                    throw new UncheckedException(e);
                    return;
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

