/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal;

import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.gradle.messaging.dispatch.Dispatch;
import org.gradle.messaging.dispatch.StoppableDispatch;
import org.gradle.messaging.remote.internal.EndOfStreamEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndOfStreamDispatch
implements StoppableDispatch<Object> {
    private final Dispatch<Object> dispatch;
    private boolean stopped;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();

    public EndOfStreamDispatch(Dispatch<Object> dispatch) {
        this.dispatch = dispatch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatch(Object message) {
        this.lock.readLock().lock();
        try {
            if (this.stopped) {
                throw new IllegalStateException(String.format("Cannot dispatch message %s, as this dispatch has been stopped.", message));
            }
            this.dispatch.dispatch(message);
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        this.lock.writeLock().lock();
        try {
            if (this.stopped) {
                return;
            }
            this.stopped = true;
            this.dispatch.dispatch(new EndOfStreamEvent());
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

