/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal;

import java.net.URI;
import org.gradle.api.Action;
import org.gradle.messaging.concurrent.ExecutorFactory;
import org.gradle.messaging.concurrent.Stoppable;
import org.gradle.messaging.concurrent.StoppableExecutor;
import org.gradle.messaging.remote.ConnectEvent;
import org.gradle.messaging.remote.internal.Connection;
import org.gradle.messaging.remote.internal.DefaultMultiChannelConnection;
import org.gradle.messaging.remote.internal.HandshakeIncomingConnector;
import org.gradle.messaging.remote.internal.HandshakeOutgoingConnector;
import org.gradle.messaging.remote.internal.IncomingConnector;
import org.gradle.messaging.remote.internal.MultiChannelConnection;
import org.gradle.messaging.remote.internal.MultiChannelConnector;
import org.gradle.messaging.remote.internal.OutgoingConnector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultMultiChannelConnector
implements MultiChannelConnector,
Stoppable {
    private final OutgoingConnector outgoingConnector;
    private final ExecutorFactory executorFactory;
    private final StoppableExecutor executorService;
    private final HandshakeIncomingConnector incomingConnector;

    public DefaultMultiChannelConnector(OutgoingConnector outgoingConnector, IncomingConnector incomingConnector, ExecutorFactory executorFactory) {
        this.outgoingConnector = new HandshakeOutgoingConnector(outgoingConnector);
        this.executorFactory = executorFactory;
        this.executorService = executorFactory.create("Incoming Connection Handler");
        this.incomingConnector = new HandshakeIncomingConnector(incomingConnector, this.executorService);
    }

    @Override
    public void stop() {
        this.executorService.stop();
    }

    @Override
    public URI accept(final Action<ConnectEvent<MultiChannelConnection<Object>>> action) {
        return this.incomingConnector.accept(new Action<ConnectEvent<Connection<Object>>>(){

            @Override
            public void execute(ConnectEvent<Connection<Object>> event) {
                DefaultMultiChannelConnector.this.finishConnect(event, action);
            }
        });
    }

    private void finishConnect(ConnectEvent<Connection<Object>> event, Action<ConnectEvent<MultiChannelConnection<Object>>> action) {
        URI localAddress = event.getLocalAddress();
        URI remoteAddress = event.getRemoteAddress();
        DefaultMultiChannelConnection channelConnection = new DefaultMultiChannelConnection(this.executorFactory, String.format("Incoming Connection %s", localAddress), event.getConnection(), localAddress, remoteAddress);
        action.execute(new ConnectEvent<DefaultMultiChannelConnection>(channelConnection, localAddress, remoteAddress));
    }

    @Override
    public MultiChannelConnection<Object> connect(URI destinationAddress) {
        Connection<Object> connection = this.outgoingConnector.connect(destinationAddress);
        return new DefaultMultiChannelConnection(this.executorFactory, String.format("Outgoing Connection %s", destinationAddress), connection, null, destinationAddress);
    }
}

