/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.api.GradleException;
import org.gradle.messaging.concurrent.CompositeStoppable;
import org.gradle.messaging.concurrent.ExecutorFactory;
import org.gradle.messaging.concurrent.Stoppable;
import org.gradle.messaging.concurrent.StoppableExecutor;
import org.gradle.messaging.dispatch.AsyncDispatch;
import org.gradle.messaging.dispatch.AsyncReceive;
import org.gradle.messaging.dispatch.DiscardOnFailureDispatch;
import org.gradle.messaging.dispatch.Dispatch;
import org.gradle.messaging.remote.internal.ChannelMessage;
import org.gradle.messaging.remote.internal.ChannelMessageMarshallingDispatch;
import org.gradle.messaging.remote.internal.ChannelMessageUnmarshallingDispatch;
import org.gradle.messaging.remote.internal.Connection;
import org.gradle.messaging.remote.internal.DefaultMultiChannelConnector;
import org.gradle.messaging.remote.internal.EndOfStreamDispatch;
import org.gradle.messaging.remote.internal.EndOfStreamFilter;
import org.gradle.messaging.remote.internal.EndOfStreamReceive;
import org.gradle.messaging.remote.internal.MultiChannelConnection;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultMultiChannelConnection
implements MultiChannelConnection<Object> {
    private final URI sourceAddress;
    private final URI destinationAddress;
    private final EndOfStreamDispatch outgoingDispatch;
    private final AsyncDispatch<Object> outgoingQueue;
    private final AsyncReceive<Object> incomingReceive;
    private final EndOfStreamFilter incomingDispatch;
    private final IncomingDemultiplex incomingDemux;
    private final StoppableExecutor executor;
    private final Connection<Object> connection;

    DefaultMultiChannelConnection(ExecutorFactory executorFactory, String displayName, Connection<Object> connection, URI sourceAddress, URI destinationAddress) {
        this.connection = connection;
        this.executor = executorFactory.create(displayName);
        this.sourceAddress = sourceAddress;
        this.destinationAddress = destinationAddress;
        this.outgoingQueue = new AsyncDispatch(this.executor);
        this.outgoingQueue.dispatchTo(this.wrapFailures(connection));
        this.outgoingDispatch = new EndOfStreamDispatch(new ChannelMessageMarshallingDispatch(this.outgoingQueue));
        this.incomingDemux = new IncomingDemultiplex();
        this.incomingDispatch = new EndOfStreamFilter(this.incomingDemux, new Runnable(){

            public void run() {
                DefaultMultiChannelConnection.this.requestStop();
            }
        });
        this.incomingReceive = new AsyncReceive<Object>(this.executor, this.wrapFailures(new ChannelMessageUnmarshallingDispatch(this.incomingDispatch)));
        this.incomingReceive.receiveFrom(new EndOfStreamReceive(connection));
    }

    private Dispatch<Object> wrapFailures(Dispatch<Object> dispatch) {
        return new DiscardOnFailureDispatch<Object>(dispatch, LoggerFactory.getLogger(DefaultMultiChannelConnector.class));
    }

    @Override
    public URI getLocalAddress() {
        if (this.sourceAddress == null) {
            throw new UnsupportedOperationException();
        }
        return this.sourceAddress;
    }

    @Override
    public URI getRemoteAddress() {
        if (this.destinationAddress == null) {
            throw new UnsupportedOperationException();
        }
        return this.destinationAddress;
    }

    @Override
    public void requestStop() {
        this.outgoingDispatch.stop();
    }

    @Override
    public void addIncomingChannel(Object channelKey, Dispatch<Object> dispatch) {
        this.incomingDemux.addIncomingChannel(channelKey, this.wrapFailures(dispatch));
    }

    @Override
    public Dispatch<Object> addOutgoingChannel(Object channelKey) {
        return new OutgoingMultiplex(channelKey, this.outgoingDispatch);
    }

    @Override
    public void stop() {
        this.executor.execute(new Runnable(){

            public void run() {
                DefaultMultiChannelConnection.this.requestStop();
                DefaultMultiChannelConnection.this.incomingDispatch.stop();
                DefaultMultiChannelConnection.this.incomingReceive.requestStop();
                DefaultMultiChannelConnection.this.outgoingQueue.requestStop();
                new CompositeStoppable(DefaultMultiChannelConnection.this.outgoingQueue, DefaultMultiChannelConnection.this.connection, DefaultMultiChannelConnection.this.incomingReceive, DefaultMultiChannelConnection.this.incomingDemux).stop();
            }
        });
        try {
            this.executor.stop(120, TimeUnit.SECONDS);
        }
        catch (Throwable e) {
            throw new GradleException("Could not stop connection.", e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OutgoingMultiplex
    implements Dispatch<Object> {
        private final Dispatch<Object> dispatch;
        private final Object channelKey;

        private OutgoingMultiplex(Object channelKey, Dispatch<Object> dispatch) {
            this.channelKey = channelKey;
            this.dispatch = dispatch;
        }

        @Override
        public void dispatch(Object message) {
            this.dispatch.dispatch(new ChannelMessage(this.channelKey, message));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IncomingDemultiplex
    implements Dispatch<Object>,
    Stoppable {
        private final Lock queueLock = new ReentrantLock();
        private final Map<Object, AsyncDispatch<Object>> incomingQueues = new HashMap<Object, AsyncDispatch<Object>>();

        private IncomingDemultiplex() {
        }

        @Override
        public void dispatch(Object message) {
            ChannelMessage channelMessage = (ChannelMessage)message;
            AsyncDispatch<Object> channel = this.findChannel(channelMessage.getChannel());
            channel.dispatch(channelMessage.getPayload());
        }

        public void addIncomingChannel(Object channel, Dispatch<Object> dispatch) {
            AsyncDispatch<Object> queue = this.findChannel(channel);
            queue.dispatchTo(dispatch);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private AsyncDispatch<Object> findChannel(Object channel) {
            AsyncDispatch<Object> queue;
            this.queueLock.lock();
            try {
                queue = this.incomingQueues.get(channel);
                if (queue == null) {
                    queue = new AsyncDispatch(DefaultMultiChannelConnection.this.executor);
                    this.incomingQueues.put(channel, queue);
                }
            }
            finally {
                this.queueLock.unlock();
            }
            return queue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stop() {
            CompositeStoppable stopper;
            this.queueLock.lock();
            try {
                stopper = new CompositeStoppable(this.incomingQueues.values());
                this.incomingQueues.clear();
            }
            finally {
                this.queueLock.unlock();
            }
            stopper.stop();
        }
    }
}

