/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal;

import java.util.HashMap;
import java.util.Map;
import org.gradle.messaging.dispatch.Dispatch;
import org.gradle.messaging.remote.internal.ChannelMessage;
import org.gradle.messaging.remote.internal.ChannelMetaInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChannelMessageMarshallingDispatch
implements Dispatch<Object> {
    private final Dispatch<Object> dispatch;
    private final Map<Object, Integer> channels = new HashMap<Object, Integer>();

    public ChannelMessageMarshallingDispatch(Dispatch<Object> dispatch) {
        this.dispatch = dispatch;
    }

    @Override
    public void dispatch(Object message) {
        if (message instanceof ChannelMessage) {
            ChannelMessage channelMessage = (ChannelMessage)message;
            Object key = channelMessage.getChannel();
            Integer id = this.channels.get(key);
            if (id == null) {
                id = this.channels.size();
                this.channels.put(key, id);
                this.dispatch.dispatch(new ChannelMetaInfo(key, id));
            }
            this.dispatch.dispatch(new ChannelMessage(id, channelMessage.getPayload()));
        } else {
            this.dispatch.dispatch(message);
        }
    }
}

