/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.dispatch;

import org.gradle.messaging.dispatch.Dispatch;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscardOnFailureDispatch<T>
implements Dispatch<T> {
    private final Dispatch<? super T> dispatch;
    private final Logger logger;

    public DiscardOnFailureDispatch(Dispatch<? super T> dispatch, Logger logger) {
        this.dispatch = dispatch;
        this.logger = logger;
    }

    @Override
    public void dispatch(T message) {
        try {
            this.dispatch.dispatch(message);
        }
        catch (Throwable e) {
            this.logger.error(String.format("Could not dispatch message %s to %s. Discarding message.", message, this.dispatch), e);
        }
    }
}

