/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.dispatch;

import java.util.concurrent.Executor;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.messaging.concurrent.AsyncStoppable;
import org.gradle.messaging.dispatch.Dispatch;
import org.gradle.messaging.dispatch.Receive;
import org.gradle.util.UncheckedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AsyncReceive<T>
implements AsyncStoppable {
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final Executor executor;
    private final Dispatch<? super T> dispatch;
    private int receivers;
    private State state = State.Init;

    public AsyncReceive(Executor executor, Dispatch<? super T> dispatch) {
        this.executor = executor;
        this.dispatch = dispatch;
    }

    public void receiveFrom(final Receive<? extends T> receive) {
        this.onReceiveThreadStart();
        this.executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    AsyncReceive.this.receiveMessages(receive);
                }
                finally {
                    AsyncReceive.this.onReceiveThreadExit();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onReceiveThreadStart() {
        this.lock.lock();
        try {
            if (this.state != State.Init) {
                throw new IllegalStateException("This receiver has been stopped.");
            }
            ++this.receivers;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onReceiveThreadExit() {
        this.lock.lock();
        try {
            --this.receivers;
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveMessages(Receive<? extends T> receive) {
        T message;
        while ((message = receive.receive()) != null) {
            this.dispatch.dispatch(message);
            this.lock.lock();
            try {
                if (this.state == State.Init) continue;
                return;
            }
            finally {
                this.lock.unlock();
                continue;
            }
            break;
        }
        return;
    }

    private void setState(State state) {
        this.state = state;
        this.condition.signalAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestStop() {
        this.lock.lock();
        try {
            this.doRequestStop();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void doRequestStop() {
        if (this.receivers > 0) {
            this.setState(State.Stopping);
        } else {
            this.setState(State.Stopped);
        }
    }

    @Override
    public void stop() {
        this.lock.lock();
        try {
            this.doRequestStop();
            while (this.receivers > 0) {
                this.condition.await();
            }
            this.setState(State.Stopped);
        }
        catch (InterruptedException e) {
            throw new UncheckedException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        Init,
        Stopping,
        Stopped;

    }
}

