/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.actor.internal;

import java.util.IdentityHashMap;
import java.util.Map;
import org.gradle.api.logging.Logging;
import org.gradle.messaging.actor.Actor;
import org.gradle.messaging.actor.ActorFactory;
import org.gradle.messaging.concurrent.CompositeStoppable;
import org.gradle.messaging.concurrent.ExecutorFactory;
import org.gradle.messaging.concurrent.Stoppable;
import org.gradle.messaging.concurrent.StoppableExecutor;
import org.gradle.messaging.dispatch.AsyncDispatch;
import org.gradle.messaging.dispatch.ExceptionTrackingDispatch;
import org.gradle.messaging.dispatch.ExceptionTrackingListener;
import org.gradle.messaging.dispatch.MethodInvocation;
import org.gradle.messaging.dispatch.ProxyDispatchAdapter;
import org.gradle.messaging.dispatch.ReflectionDispatch;
import org.gradle.messaging.dispatch.StoppableDispatch;

public class DefaultActorFactory
implements ActorFactory,
Stoppable {
    private final Map<Object, ActorImpl> actors = new IdentityHashMap<Object, ActorImpl>();
    private final Object lock = new Object();
    private final ExecutorFactory executorFactory;

    public DefaultActorFactory(ExecutorFactory executorFactory) {
        this.executorFactory = executorFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            try {
                new CompositeStoppable(this.actors.values()).stop();
            }
            finally {
                this.actors.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Actor createActor(Object target) {
        if (target instanceof ActorImpl) {
            return (ActorImpl)target;
        }
        Object object = this.lock;
        synchronized (object) {
            ActorImpl actor = this.actors.get(target);
            if (actor == null) {
                actor = new ActorImpl(target);
                this.actors.put(target, actor);
            }
            return actor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopped(ActorImpl actor) {
        Object object = this.lock;
        synchronized (object) {
            this.actors.values().remove(actor);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ActorImpl
    implements Actor {
        private final StoppableDispatch<MethodInvocation> dispatch;
        private final StoppableExecutor executor;
        private final ExceptionTrackingListener exceptionListener;

        public ActorImpl(Object targetObject) {
            this.executor = DefaultActorFactory.this.executorFactory.create(String.format("Dispatch %s", targetObject));
            this.exceptionListener = new ExceptionTrackingListener(Logging.getLogger(ActorImpl.class));
            this.dispatch = new AsyncDispatch<MethodInvocation>(this.executor, new ExceptionTrackingDispatch<MethodInvocation>(new ReflectionDispatch(targetObject), this.exceptionListener));
        }

        @Override
        public <T> T getProxy(Class<T> type) {
            return new ProxyDispatchAdapter<T>(type, this).getSource();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stop() {
            try {
                new CompositeStoppable(this.dispatch, this.executor, this.exceptionListener).stop();
            }
            finally {
                DefaultActorFactory.this.stopped(this);
            }
        }

        @Override
        public void dispatch(MethodInvocation message) {
            this.dispatch.dispatch(message);
        }
    }
}

