/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.logging.internal;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.fusesource.jansi.WindowsAnsiOutputStream;
import org.gradle.api.GradleException;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.specs.Spec;
import org.gradle.util.OperatingSystem;
import org.gradle.util.PosixUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TerminalDetector
implements Spec<FileDescriptor> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TerminalDetector(File libCacheDir) {
        File tmpDir = new File(libCacheDir, "jna");
        tmpDir.mkdirs();
        String libName = System.mapLibraryName("jnidispatch");
        File libFile = new File(tmpDir, libName);
        if (!libFile.exists()) {
            String resourceName = "/com/sun/jna/" + OperatingSystem.current().getNativePrefix() + "/" + libName;
            try {
                InputStream lib = this.getClass().getResourceAsStream(resourceName);
                if (lib == null) {
                    throw new GradleException(String.format("Could not locate JNA native lib resource '%s'.", resourceName));
                }
                try {
                    FileOutputStream outputStream = new FileOutputStream(libFile);
                    try {
                        IOUtils.copy((InputStream)lib, (OutputStream)outputStream);
                    }
                    finally {
                        outputStream.close();
                    }
                }
                finally {
                    lib.close();
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        System.setProperty("jna.boot.library.path", tmpDir.getAbsolutePath());
    }

    @Override
    public boolean isSatisfiedBy(FileDescriptor element) {
        if (OperatingSystem.current().isWindows()) {
            try {
                new WindowsAnsiOutputStream((OutputStream)new ByteArrayOutputStream());
                return true;
            }
            catch (IOException ignore) {
                return false;
            }
        }
        if (!PosixUtil.current().isatty(element)) {
            return false;
        }
        String term = System.getenv("TERM");
        return term == null || !term.equals("dumb");
    }
}

