/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.logging.internal;

import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.StandardOutputListener;
import org.gradle.logging.LoggingManagerInternal;
import org.gradle.logging.internal.LoggingOutputInternal;
import org.gradle.logging.internal.LoggingSystem;
import org.gradle.logging.internal.OutputEventListener;
import org.gradle.messaging.concurrent.CompositeStoppable;
import org.gradle.messaging.concurrent.Stoppable;

public class DefaultLoggingManager
implements LoggingManagerInternal {
    private boolean started;
    private final StartableLoggingSystem loggingSystem;
    private final StartableLoggingSystem stdOutLoggingSystem;
    private final StartableLoggingSystem stdErrLoggingSystem;
    private final LoggingOutputInternal loggingOutput;
    private final Set<StandardOutputListener> stdoutListeners = new LinkedHashSet<StandardOutputListener>();
    private final Set<StandardOutputListener> stderrListeners = new LinkedHashSet<StandardOutputListener>();
    private final Set<OutputEventListener> outputEventListeners = new LinkedHashSet<OutputEventListener>();

    public DefaultLoggingManager(LoggingSystem loggingSystem, LoggingSystem stdOutLoggingSystem, LoggingSystem stdErrLoggingSystem, LoggingOutputInternal loggingOutput) {
        this.loggingOutput = loggingOutput;
        this.loggingSystem = new StartableLoggingSystem(loggingSystem, null);
        this.stdOutLoggingSystem = new StartableLoggingSystem(stdOutLoggingSystem, LogLevel.QUIET);
        this.stdErrLoggingSystem = new StartableLoggingSystem(stdErrLoggingSystem, LogLevel.ERROR);
    }

    public DefaultLoggingManager start() {
        this.started = true;
        for (StandardOutputListener stdoutListener : this.stdoutListeners) {
            this.loggingOutput.addStandardOutputListener(stdoutListener);
        }
        for (StandardOutputListener stderrListener : this.stderrListeners) {
            this.loggingOutput.addStandardErrorListener(stderrListener);
        }
        for (OutputEventListener outputEventListener : this.outputEventListeners) {
            this.loggingOutput.addOutputEventListener(outputEventListener);
        }
        this.loggingSystem.start();
        this.stdOutLoggingSystem.start();
        this.stdErrLoggingSystem.start();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultLoggingManager stop() {
        try {
            new CompositeStoppable(this.loggingSystem, this.stdOutLoggingSystem, this.stdErrLoggingSystem).stop();
            for (StandardOutputListener stdoutListener : this.stdoutListeners) {
                this.loggingOutput.removeStandardOutputListener(stdoutListener);
            }
            for (StandardOutputListener stderrListener : this.stderrListeners) {
                this.loggingOutput.removeStandardErrorListener(stderrListener);
            }
            for (OutputEventListener listener : this.outputEventListeners) {
                this.loggingOutput.removeOutputEventListener(listener);
            }
        }
        finally {
            this.started = false;
        }
        return this;
    }

    public DefaultLoggingManager setLevel(LogLevel logLevel) {
        this.loggingSystem.setLevel(logLevel);
        return this;
    }

    public LogLevel getLevel() {
        return this.loggingSystem.level;
    }

    public LogLevel getStandardOutputCaptureLevel() {
        return this.stdOutLoggingSystem.level;
    }

    public boolean isStandardOutputCaptureEnabled() {
        return this.getStandardOutputCaptureLevel() != null;
    }

    public DefaultLoggingManager captureStandardOutput(LogLevel level) {
        this.stdOutLoggingSystem.setLevel(level);
        return this;
    }

    public DefaultLoggingManager captureStandardError(LogLevel level) {
        this.stdErrLoggingSystem.setLevel(level);
        return this;
    }

    public DefaultLoggingManager disableStandardOutputCapture() {
        this.stdOutLoggingSystem.disable();
        this.stdErrLoggingSystem.disable();
        return this;
    }

    public LogLevel getStandardErrorCaptureLevel() {
        return this.stdErrLoggingSystem.level;
    }

    public void addStandardOutputListener(StandardOutputListener listener) {
        if (this.stdoutListeners.add(listener) && this.started) {
            this.loggingOutput.addStandardOutputListener(listener);
        }
    }

    public void addStandardErrorListener(StandardOutputListener listener) {
        if (this.stderrListeners.add(listener) && this.started) {
            this.loggingOutput.addStandardErrorListener(listener);
        }
    }

    public void removeStandardOutputListener(StandardOutputListener listener) {
        if (this.stdoutListeners.remove(listener) && this.started) {
            this.loggingOutput.removeStandardOutputListener(listener);
        }
    }

    public void removeStandardErrorListener(StandardOutputListener listener) {
        if (this.stderrListeners.remove(listener) && this.started) {
            this.loggingOutput.removeStandardErrorListener(listener);
        }
    }

    public void addOutputEventListener(OutputEventListener listener) {
        if (this.outputEventListeners.add(listener) && this.started) {
            this.loggingOutput.addOutputEventListener(listener);
        }
    }

    public void removeOutputEventListener(OutputEventListener listener) {
        if (this.outputEventListeners.remove(listener) && this.started) {
            this.loggingOutput.removeOutputEventListener(listener);
        }
    }

    public void colorStdOutAndStdErr(boolean colorOutput) {
        this.loggingOutput.colorStdOutAndStdErr(colorOutput);
    }

    private static class StartableLoggingSystem
    implements Stoppable {
        private final LoggingSystem loggingSystem;
        private LogLevel level;
        private boolean disable;
        private LoggingSystem.Snapshot originalState;

        private StartableLoggingSystem(LoggingSystem loggingSystem, LogLevel level) {
            this.loggingSystem = loggingSystem;
            this.level = level;
        }

        public void start() {
            this.originalState = this.disable ? this.loggingSystem.off() : (this.level != null ? this.loggingSystem.on(this.level) : this.loggingSystem.snapshot());
        }

        public void setLevel(LogLevel logLevel) {
            if (this.level == logLevel) {
                return;
            }
            this.level = logLevel;
            this.disable = false;
            if (this.originalState == null) {
                return;
            }
            this.loggingSystem.on(logLevel);
        }

        public void disable() {
            this.level = null;
            this.disable = true;
            if (this.originalState != null) {
                this.loggingSystem.off();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            try {
                if (this.originalState != null) {
                    this.loggingSystem.restore(this.originalState);
                }
            }
            finally {
                this.originalState = null;
            }
        }
    }
}

