/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.logging.internal;

import java.util.LinkedList;
import org.gradle.logging.internal.Console;
import org.gradle.logging.internal.Label;
import org.gradle.logging.internal.OutputEvent;
import org.gradle.logging.internal.OutputEventListener;
import org.gradle.logging.internal.ProgressCompleteEvent;
import org.gradle.logging.internal.ProgressEvent;
import org.gradle.logging.internal.ProgressStartEvent;
import org.gradle.util.GUtil;

public class ConsoleBackedProgressRenderer
implements OutputEventListener {
    private final OutputEventListener listener;
    private final Console console;
    private final LinkedList<Operation> operations = new LinkedList();
    private Label statusBar;

    public ConsoleBackedProgressRenderer(OutputEventListener listener, Console console) {
        this.listener = listener;
        this.console = console;
    }

    public void onOutput(OutputEvent event) {
        if (event instanceof ProgressStartEvent) {
            ProgressStartEvent startEvent = (ProgressStartEvent)event;
            this.operations.addLast(new Operation(startEvent.getShortDescription(), startEvent.getStatus()));
            this.updateText();
        } else if (event instanceof ProgressCompleteEvent) {
            this.operations.removeLast();
            this.updateText();
        } else if (event instanceof ProgressEvent) {
            ProgressEvent progressEvent = (ProgressEvent)event;
            this.operations.getLast().status = progressEvent.getStatus();
            this.updateText();
        }
        this.listener.onOutput(event);
    }

    private void updateText() {
        StringBuilder builder = new StringBuilder();
        for (Operation operation : this.operations) {
            String message = operation.getMessage();
            if (message == null) continue;
            if (builder.length() > 0) {
                builder.append(' ');
            }
            builder.append("> ");
            builder.append(message);
        }
        if (this.statusBar == null) {
            this.statusBar = this.console.getStatusBar();
        }
        this.statusBar.setText(builder.toString());
    }

    private static class Operation {
        private final String shortDescription;
        private String status;

        private Operation(String shortDescription, String status) {
            this.shortDescription = shortDescription;
            this.status = status;
        }

        String getMessage() {
            if (GUtil.isTrue(this.status)) {
                return this.status;
            }
            if (GUtil.isTrue(this.shortDescription)) {
                return this.shortDescription;
            }
            return null;
        }
    }
}

