/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.logging.internal;

import java.io.Flushable;
import java.io.IOException;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.fusesource.jansi.Ansi;
import org.gradle.api.Action;
import org.gradle.api.UncheckedIOException;
import org.gradle.logging.internal.AbstractStyledTextOutput;
import org.gradle.logging.internal.ColorMap;
import org.gradle.logging.internal.Console;
import org.gradle.logging.internal.Label;
import org.gradle.logging.internal.TextArea;
import org.gradle.util.SystemProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnsiConsole
implements Console {
    private static final String EOL = SystemProperties.getLineSeparator();
    private final Appendable target;
    private final Flushable flushable;
    private LabelImpl statusBar;
    private final TextAreaImpl textArea;
    private final Screen container;
    private final ColorMap colorMap;

    public AnsiConsole(Appendable target, Flushable flushable, ColorMap colorMap) {
        this.target = target;
        this.flushable = flushable;
        this.colorMap = colorMap;
        this.container = new Screen();
        this.textArea = new TextAreaImpl(this.container);
    }

    @Override
    public Label getStatusBar() {
        if (this.statusBar == null) {
            this.statusBar = new LabelImpl(this.container);
            this.render(new Action<Ansi>(){

                @Override
                public void execute(Ansi ansi) {
                    AnsiConsole.this.textArea.onDeactivate(ansi);
                    AnsiConsole.this.statusBar.onActivate(ansi);
                }
            });
        }
        return this.statusBar;
    }

    @Override
    public TextArea getMainArea() {
        return this.textArea;
    }

    private void render(Action<Ansi> action) {
        Ansi ansi = this.createAnsi();
        action.execute(ansi);
        try {
            this.target.append(ansi.toString());
            this.flushable.flush();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    Ansi createAnsi() {
        return Ansi.ansi();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LineSplitter
    implements Iterator<String> {
        private final CharSequence text;
        private int start;
        private int end;

        private LineSplitter(CharSequence text) {
            this.text = text;
            this.findNext();
        }

        public boolean findNext() {
            if (this.end == this.text.length()) {
                this.start = -1;
                return false;
            }
            if (this.startsWithEol(this.text, this.end)) {
                this.start = this.end;
                this.end = this.start + EOL.length();
                return true;
            }
            for (int pos = this.end; pos < this.text.length(); ++pos) {
                if (!this.startsWithEol(this.text, pos)) continue;
                this.start = this.end;
                this.end = pos;
                return true;
            }
            this.start = this.end;
            this.end = this.text.length();
            return true;
        }

        private boolean startsWithEol(CharSequence text, int startAt) {
            if (startAt + EOL.length() > text.length()) {
                return false;
            }
            for (int i = 0; i < EOL.length(); ++i) {
                if (EOL.charAt(i) == text.charAt(startAt + i)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean hasNext() {
            return this.start >= 0;
        }

        @Override
        public String next() {
            CharSequence next = this.text.subSequence(this.start, this.end);
            this.findNext();
            return ((Object)next).toString();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class TextAreaImpl
    extends AbstractStyledTextOutput
    implements TextArea,
    Widget {
        private final Container container;
        private int width;
        boolean extraEol;

        private TextAreaImpl(Container container) {
            this.container = container;
        }

        public void onDeactivate(Ansi ansi) {
            if (this.width > 0) {
                ansi.newline();
                this.extraEol = true;
            }
        }

        public void onActivate(Ansi ansi) {
            if (this.extraEol) {
                ansi.cursorUp(1);
                ansi.cursorRight(this.width);
                this.extraEol = false;
            }
        }

        protected void doAppend(final String text) {
            if (text.length() == 0) {
                return;
            }
            this.container.redraw(this, new Action<Ansi>(){

                @Override
                public void execute(Ansi ansi) {
                    ColorMap.Color color = AnsiConsole.this.colorMap.getColourFor(TextAreaImpl.this.getStyle());
                    color.on(ansi);
                    LineSplitter tokenizer = new LineSplitter(text);
                    while (tokenizer.hasNext()) {
                        String token = (String)tokenizer.next();
                        if (token.equals(EOL)) {
                            TextAreaImpl.this.width = 0;
                            TextAreaImpl.this.extraEol = false;
                        } else {
                            TextAreaImpl.this.width += token.length();
                        }
                        ansi.a(token);
                    }
                    color.off(ansi);
                }
            });
        }
    }

    private class LabelImpl
    implements Label,
    Widget {
        private final Container container;
        private String text = "";
        private String displayedText = "";

        public LabelImpl(Container container) {
            this.container = container;
        }

        public void setText(String text) {
            if (text.equals(this.text)) {
                return;
            }
            this.text = text;
            this.container.redraw(this, new Action<Ansi>(){

                @Override
                public void execute(Ansi ansi) {
                    LabelImpl.this.draw(ansi);
                }
            });
        }

        public void close() {
            this.container.close(this);
        }

        public void onDeactivate(Ansi ansi) {
            if (this.displayedText.length() > 0) {
                ansi.cursorLeft(this.displayedText.length());
                ansi.eraseLine(Ansi.Erase.FORWARD);
                this.displayedText = "";
            }
        }

        public void onActivate(Ansi ansi) {
            this.draw(ansi);
        }

        public void draw(Ansi ansi) {
            String prefix = StringUtils.getCommonPrefix((String[])new String[]{this.text, this.displayedText});
            if (prefix.length() < this.displayedText.length()) {
                ansi.cursorLeft(this.displayedText.length() - prefix.length());
            }
            if (prefix.length() < this.text.length()) {
                ColorMap.Color color = AnsiConsole.this.colorMap.getStatusBarColor();
                color.on(ansi);
                ansi.a(this.text.substring(prefix.length()));
                color.off(ansi);
            }
            if (this.displayedText.length() > this.text.length()) {
                ansi.eraseLine(Ansi.Erase.FORWARD);
            }
            this.displayedText = this.text;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Screen
    implements Container {
        private Screen() {
        }

        @Override
        public void redraw(Widget widget, final Action<Ansi> drawOperation) {
            if (widget == AnsiConsole.this.textArea) {
                AnsiConsole.this.render(new Action<Ansi>(){

                    @Override
                    public void execute(Ansi ansi) {
                        if (AnsiConsole.this.statusBar != null) {
                            AnsiConsole.this.statusBar.onDeactivate(ansi);
                            AnsiConsole.this.textArea.onActivate(ansi);
                        }
                        drawOperation.execute(ansi);
                        if (AnsiConsole.this.statusBar != null) {
                            AnsiConsole.this.textArea.onDeactivate(ansi);
                            AnsiConsole.this.statusBar.onActivate(ansi);
                        }
                    }
                });
            } else {
                assert (widget == AnsiConsole.this.statusBar);
                AnsiConsole.this.render(new Action<Ansi>(){

                    @Override
                    public void execute(Ansi ansi) {
                        drawOperation.execute(ansi);
                    }
                });
            }
        }

        @Override
        public void close(Widget widget) {
            if (widget == AnsiConsole.this.textArea) {
                throw new UnsupportedOperationException();
            }
            if (widget == AnsiConsole.this.statusBar) {
                AnsiConsole.this.render(new Action<Ansi>(){

                    @Override
                    public void execute(Ansi ansi) {
                        AnsiConsole.this.statusBar.onDeactivate(ansi);
                        AnsiConsole.this.textArea.onActivate(ansi);
                        AnsiConsole.this.statusBar = null;
                    }
                });
            }
        }
    }

    private static interface Widget {
        public void onActivate(Ansi var1);

        public void onDeactivate(Ansi var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Container {
        public void redraw(Widget var1, Action<Ansi> var2);

        public void close(Widget var1);
    }
}

