/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.logging;

import org.gradle.StartParameter;
import org.gradle.api.internal.Factory;
import org.gradle.api.internal.project.DefaultServiceRegistry;
import org.gradle.api.specs.Specs;
import org.gradle.initialization.CommandLineConverter;
import org.gradle.logging.LoggingConfiguration;
import org.gradle.logging.LoggingManagerInternal;
import org.gradle.logging.ProgressLoggerFactory;
import org.gradle.logging.StyledTextOutputFactory;
import org.gradle.logging.internal.DefaultLoggingConfigurer;
import org.gradle.logging.internal.DefaultLoggingManagerFactory;
import org.gradle.logging.internal.DefaultProgressLoggerFactory;
import org.gradle.logging.internal.DefaultStyledTextOutputFactory;
import org.gradle.logging.internal.JavaUtilLoggingConfigurer;
import org.gradle.logging.internal.LoggingCommandLineConverter;
import org.gradle.logging.internal.LoggingSystem;
import org.gradle.logging.internal.OutputEventListener;
import org.gradle.logging.internal.OutputEventRenderer;
import org.gradle.logging.internal.ProgressLoggingBridge;
import org.gradle.logging.internal.Slf4jLoggingConfigurer;
import org.gradle.logging.internal.StdErrLoggingSystem;
import org.gradle.logging.internal.StdOutLoggingSystem;
import org.gradle.logging.internal.TerminalDetector;
import org.gradle.logging.internal.TextStreamOutputEventListener;
import org.gradle.util.TimeProvider;
import org.gradle.util.TrueTimeProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingServiceRegistry
extends DefaultServiceRegistry {
    private TextStreamOutputEventListener stdoutListener;
    private final boolean detectConsole;

    LoggingServiceRegistry() {
        this(true);
    }

    LoggingServiceRegistry(boolean detectConsole) {
        this.detectConsole = detectConsole;
        this.stdoutListener = new TextStreamOutputEventListener(this.get(OutputEventListener.class));
    }

    public static LoggingServiceRegistry newCommandLineProcessLogging() {
        return new LoggingServiceRegistry(true);
    }

    public static LoggingServiceRegistry newChildProcessLogging() {
        return new LoggingServiceRegistry(false);
    }

    public static LoggingServiceRegistry newEmbeddableLogging() {
        return new LoggingServiceRegistry(false);
    }

    protected CommandLineConverter<LoggingConfiguration> createCommandLineConverter() {
        return new LoggingCommandLineConverter();
    }

    protected TimeProvider createTimeProvider() {
        return new TrueTimeProvider();
    }

    protected StdOutLoggingSystem createStdOutLoggingSystem() {
        return new StdOutLoggingSystem(this.stdoutListener, this.get(TimeProvider.class));
    }

    protected StyledTextOutputFactory createStyledTextOutputFactory() {
        return new DefaultStyledTextOutputFactory(this.stdoutListener, this.get(TimeProvider.class));
    }

    protected StdErrLoggingSystem createStdErrLoggingSystem() {
        return new StdErrLoggingSystem(new TextStreamOutputEventListener(this.get(OutputEventListener.class)), this.get(TimeProvider.class));
    }

    protected ProgressLoggerFactory createProgressLoggerFactory() {
        return new DefaultProgressLoggerFactory(new ProgressLoggingBridge(this.get(OutputEventListener.class)), this.get(TimeProvider.class));
    }

    protected Factory<LoggingManagerInternal> createLoggingManagerFactory() {
        OutputEventRenderer renderer = this.get(OutputEventRenderer.class);
        Slf4jLoggingConfigurer slf4jConfigurer = new Slf4jLoggingConfigurer(renderer);
        DefaultLoggingConfigurer compositeConfigurer = new DefaultLoggingConfigurer(renderer, slf4jConfigurer, new JavaUtilLoggingConfigurer());
        return new DefaultLoggingManagerFactory(compositeConfigurer, renderer, this.getStdOutLoggingSystem(), this.getStdErrLoggingSystem());
    }

    private LoggingSystem getStdErrLoggingSystem() {
        return this.get(StdErrLoggingSystem.class);
    }

    private LoggingSystem getStdOutLoggingSystem() {
        return this.get(StdOutLoggingSystem.class);
    }

    protected OutputEventRenderer createOutputEventRenderer() {
        TerminalDetector terminalDetector = this.detectConsole ? new TerminalDetector(StartParameter.DEFAULT_GRADLE_USER_HOME) : Specs.satisfyNone();
        return new OutputEventRenderer(terminalDetector).addStandardOutputAndError();
    }
}

