/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.io.File;
import java.util.List;
import org.gradle.api.internal.GradleInternal;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.groovy.scripts.UriScriptSource;
import org.gradle.initialization.InitScriptFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserHomeInitScriptFinder
implements InitScriptFinder {
    public static final String DEFAULT_INIT_SCRIPT_NAME = "init.gradle";
    private final InitScriptFinder finder;

    public UserHomeInitScriptFinder(InitScriptFinder finder) {
        this.finder = finder;
    }

    @Override
    public List<ScriptSource> findScripts(GradleInternal gradle) {
        List<ScriptSource> scripts = this.finder.findScripts(gradle);
        File userHomeDir = gradle.getStartParameter().getGradleUserHomeDir();
        File userInitScript = new File(userHomeDir, DEFAULT_INIT_SCRIPT_NAME);
        if (userInitScript.isFile()) {
            scripts.add(new UriScriptSource("initialization script", userInitScript));
        }
        return scripts;
    }
}

