/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import org.apache.tools.ant.Project;
import org.gradle.api.internal.ClassPathRegistry;
import org.gradle.initialization.ClassLoaderFactory;
import org.gradle.util.ClasspathUtil;
import org.gradle.util.GFileUtils;
import org.gradle.util.Jvm;
import org.gradle.util.MultiParentClassLoader;

public class DefaultClassLoaderFactory
implements ClassLoaderFactory {
    private final URLClassLoader rootClassLoader;
    private final URLClassLoader coreImplClassLoader;

    public DefaultClassLoaderFactory(ClassPathRegistry classPathRegistry) {
        ClassLoader antClassloader = Project.class.getClassLoader();
        File toolsJar = Jvm.current().getToolsJar();
        if (toolsJar != null) {
            ClasspathUtil.addUrl((URLClassLoader)antClassloader, GFileUtils.toURLs(Collections.singleton(toolsJar)));
        }
        ClassLoader runtimeClassloader = this.getClass().getClassLoader();
        URL[] pluginsClassPath = classPathRegistry.getClassPathUrls("GRADLE_PLUGINS");
        this.rootClassLoader = new URLClassLoader(pluginsClassPath, runtimeClassloader);
        URL[] coreImplClassPath = classPathRegistry.getClassPathUrls("GRADLE_CORE_IMPL");
        this.coreImplClassLoader = new URLClassLoader(coreImplClassPath, (ClassLoader)this.rootClassLoader);
    }

    public ClassLoader getRootClassLoader() {
        return this.rootClassLoader;
    }

    public ClassLoader getCoreImplClassLoader() {
        return this.coreImplClassLoader;
    }

    public MultiParentClassLoader createScriptClassLoader() {
        return new MultiParentClassLoader(new ClassLoader[]{this.rootClassLoader});
    }
}

