/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.util.ArrayList;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.internal.project.IProjectRegistry;
import org.gradle.api.internal.project.ProjectIdentifier;
import org.gradle.initialization.ProjectSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProjectSpec
implements ProjectSpec {
    @Override
    public boolean containsProject(IProjectRegistry<?> registry) {
        this.checkPreconditions(registry);
        for (ProjectIdentifier project : registry.getAllProjects()) {
            if (!this.select(project)) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T extends ProjectIdentifier> T selectProject(IProjectRegistry<? extends T> registry) {
        this.checkPreconditions(registry);
        ArrayList<ProjectIdentifier> matches = new ArrayList<ProjectIdentifier>();
        for (ProjectIdentifier project : registry.getAllProjects()) {
            if (!this.select(project)) continue;
            matches.add(project);
        }
        if (matches.isEmpty()) {
            throw new InvalidUserDataException(this.formatNoMatchesMessage());
        }
        if (matches.size() != 1) {
            throw new InvalidUserDataException(this.formatMultipleMatchesMessage(matches));
        }
        return (T)((ProjectIdentifier)matches.get(0));
    }

    protected void checkPreconditions(IProjectRegistry<?> registry) {
    }

    protected abstract String formatMultipleMatchesMessage(Iterable<? extends ProjectIdentifier> var1);

    protected abstract String formatNoMatchesMessage();

    protected abstract boolean select(ProjectIdentifier var1);
}

