/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.groovy.scripts;

import groovy.lang.Script;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.groovy.scripts.ScriptCompilationHandler;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.groovy.scripts.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingScriptCompilationHandler
implements ScriptCompilationHandler {
    private final ScriptCompilationHandler handler;
    private final Map<Collection<Object>, Class<?>> cachedClasses = new HashMap();

    public CachingScriptCompilationHandler(ScriptCompilationHandler handler) {
        this.handler = handler;
    }

    @Override
    public void compileToDir(ScriptSource source, ClassLoader classLoader, File scriptCacheDir, Transformer transformer, Class<? extends Script> scriptBaseClass) {
        this.handler.compileToDir(source, classLoader, scriptCacheDir, transformer, scriptBaseClass);
    }

    @Override
    public <T extends Script> Class<? extends T> loadFromDir(ScriptSource source, ClassLoader classLoader, File scriptCacheDir, Class<T> scriptBaseClass) {
        List<Object> key = Arrays.asList(source.getClassName(), classLoader, scriptCacheDir);
        Class<Object> c = this.cachedClasses.get(key);
        if (c == null) {
            c = this.handler.loadFromDir(source, classLoader, scriptCacheDir, scriptBaseClass);
            this.cachedClasses.put(key, c);
        }
        return c.asSubclass(scriptBaseClass);
    }
}

