/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Task;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.tasks.CommandLineOption;
import org.gradle.execution.BuildExecuter;
import org.gradle.execution.TaskGraphExecuter;
import org.gradle.execution.TaskNameResolver;
import org.gradle.execution.TaskSelector;
import org.gradle.initialization.CommandLineParser;
import org.gradle.initialization.ParsedCommandLine;
import org.gradle.util.GUtil;
import org.gradle.util.JavaMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskNameResolvingBuildExecuter
implements BuildExecuter {
    private final List<String> names;
    private String description;
    private TaskGraphExecuter executer;
    private final TaskNameResolver taskNameResolver;

    public TaskNameResolvingBuildExecuter(Collection<String> names) {
        this(names, new TaskNameResolver());
    }

    TaskNameResolvingBuildExecuter(Collection<String> names, TaskNameResolver taskNameResolver) {
        this.taskNameResolver = taskNameResolver;
        this.names = new ArrayList<String>(names);
    }

    public List<String> getNames() {
        return this.names;
    }

    @Override
    public void select(GradleInternal gradle) {
        Multimap<String, Task> selectedTasks = this.doSelect(gradle, this.names, this.taskNameResolver);
        this.executer = gradle.getTaskGraph();
        for (String name : selectedTasks.keySet()) {
            this.executer.addTasks(selectedTasks.get((Object)name));
        }
        this.description = selectedTasks.keySet().size() == 1 ? String.format("primary task %s", GUtil.toString(selectedTasks.keySet())) : String.format("primary tasks %s", GUtil.toString(selectedTasks.keySet()));
    }

    private Multimap<String, Task> doSelect(GradleInternal gradle, List<String> paths, TaskNameResolver taskNameResolver) {
        LinkedHashMultimap matches = LinkedHashMultimap.create();
        TaskSelector selector = new TaskSelector(taskNameResolver);
        List<String> remainingPaths = paths;
        while (!remainingPaths.isEmpty()) {
            String path = remainingPaths.get(0);
            selector.selectTasks(gradle, path);
            CommandLineParser commandLineParser = new CommandLineParser();
            Set<Task> tasks = selector.getTasks();
            HashMap<String, JavaMethod<Task, Object>> options = new HashMap<String, JavaMethod<Task, Object>>();
            if (tasks.size() == 1) {
                for (Class<?> type = tasks.iterator().next().getClass(); type != Object.class; type = type.getSuperclass()) {
                    for (Method method : type.getDeclaredMethods()) {
                        CommandLineOption commandLineOption = method.getAnnotation(CommandLineOption.class);
                        if (commandLineOption == null) continue;
                        commandLineParser.option(commandLineOption.options()).hasDescription(commandLineOption.description());
                        options.put(commandLineOption.options()[0], new JavaMethod<Task, Object>(Task.class, Object.class, method));
                    }
                }
            }
            ParsedCommandLine commandLine = commandLineParser.parse(remainingPaths.subList(1, remainingPaths.size()));
            for (Map.Entry entry : options.entrySet()) {
                if (!commandLine.hasOption((String)entry.getKey())) continue;
                for (Task task : tasks) {
                    ((JavaMethod)entry.getValue()).invoke(task, true);
                }
            }
            remainingPaths = commandLine.getExtraArguments();
            matches.putAll((Object)selector.getTaskName(), tasks);
        }
        return matches;
    }

    @Override
    public String getDisplayName() {
        return this.description;
    }

    @Override
    public void execute() {
        this.executer.execute();
    }
}

