/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution;

import java.util.Arrays;
import java.util.List;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.execution.DelegatingBuildExecuter;
import org.gradle.execution.TaskNameResolvingBuildExecuter;
import org.gradle.util.GUtil;

public class ProjectDefaultsBuildExecuter
extends DelegatingBuildExecuter {
    private List<String> defaultTasks;
    private String displayName;

    public void select(GradleInternal gradle) {
        if (this.getDelegate() == null) {
            ProjectInternal project = gradle.getDefaultProject();
            this.defaultTasks = project.getDefaultTasks();
            this.displayName = String.format("project default tasks %s", GUtil.toString(this.defaultTasks));
            if (this.defaultTasks.size() == 0) {
                this.defaultTasks = Arrays.asList("help");
                this.displayName = String.format("default task %s", GUtil.toString(this.defaultTasks));
            }
            this.setDelegate(new TaskNameResolvingBuildExecuter(this.defaultTasks));
        }
        super.select(gradle);
    }

    public String getDisplayName() {
        return this.displayName;
    }
}

