/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.specs;

import groovy.lang.Closure;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.specs.AndSpec;
import org.gradle.api.specs.NotSpec;
import org.gradle.api.specs.OrSpec;
import org.gradle.api.specs.Spec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Specs {
    public static final Spec SATISFIES_ALL = new Spec(){

        public boolean isSatisfiedBy(Object dependency) {
            return true;
        }
    };

    public static <T> Spec<T> satisfyAll() {
        return new Spec<T>(){

            @Override
            public boolean isSatisfiedBy(T element) {
                return true;
            }
        };
    }

    public static <T> Spec<T> satisfyNone() {
        return new Spec<T>(){

            @Override
            public boolean isSatisfiedBy(T element) {
                return false;
            }
        };
    }

    public static <T> Spec<T> convertClosureToSpec(final Closure cl) {
        return new Spec<T>(){

            @Override
            public boolean isSatisfiedBy(T element) {
                Object value = cl.call(element);
                return value == null ? false : (Boolean)value;
            }
        };
    }

    public static <T> Set<T> filterIterable(Iterable<? extends T> iterable, Spec<? super T> spec) {
        LinkedHashSet<T> result = new LinkedHashSet<T>();
        for (T t : iterable) {
            if (!spec.isSatisfiedBy(t)) continue;
            result.add(t);
        }
        return result;
    }

    public static <T> AndSpec<T> and(Spec<? super T> ... specs) {
        return new AndSpec<T>(specs);
    }

    public static <T> OrSpec<T> or(Spec<? super T> ... specs) {
        return new OrSpec<T>(specs);
    }

    public static <T> NotSpec<T> not(Spec<? super T> spec) {
        return new NotSpec<T>(spec);
    }

    public static <T> Spec<T> or(final boolean defaultWhenNoSpecs, List<? extends Spec<? super T>> specs) {
        if (specs.isEmpty()) {
            return new Spec<T>(){

                @Override
                public boolean isSatisfiedBy(T element) {
                    return defaultWhenNoSpecs;
                }
            };
        }
        return new OrSpec(specs.toArray(new Spec[specs.size()]));
    }
}

