/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import groovy.lang.Closure;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.TaskExecutionHistory;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.collections.DefaultConfigurableFileCollection;
import org.gradle.api.specs.AndSpec;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskOutputs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTaskOutputs
implements TaskOutputsInternal {
    private final DefaultConfigurableFileCollection outputFiles;
    private AndSpec<TaskInternal> upToDateSpec = new AndSpec(new Spec[0]);
    private TaskExecutionHistory history;

    public DefaultTaskOutputs(FileResolver resolver, TaskInternal task) {
        this.outputFiles = new DefaultConfigurableFileCollection(String.format("%s output files", task), resolver, null, new Object[0]);
        this.outputFiles.builtBy(task);
    }

    @Override
    public Spec<? super TaskInternal> getUpToDateSpec() {
        return this.upToDateSpec;
    }

    @Override
    public void upToDateWhen(Closure upToDateClosure) {
        this.upToDateSpec = this.upToDateSpec.and(upToDateClosure);
    }

    @Override
    public void upToDateWhen(Spec<? super Task> upToDateSpec) {
        this.upToDateSpec = this.upToDateSpec.and(upToDateSpec);
    }

    @Override
    public boolean getHasOutput() {
        return !this.outputFiles.getFrom().isEmpty() || !this.upToDateSpec.getSpecs().isEmpty();
    }

    @Override
    public FileCollection getFiles() {
        return this.outputFiles;
    }

    @Override
    public TaskOutputs files(Object ... paths) {
        this.outputFiles.from(paths);
        return this;
    }

    @Override
    public TaskOutputs file(Object path) {
        this.files(path);
        return this;
    }

    @Override
    public TaskOutputs dir(Object path) {
        this.files(path);
        return this;
    }

    @Override
    public FileCollection getPreviousFiles() {
        if (this.history == null) {
            throw new IllegalStateException("Task history is currently not available for this task.");
        }
        return this.history.getOutputFiles();
    }

    @Override
    public void setHistory(TaskExecutionHistory history) {
        this.history = history;
    }
}

