/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.Buildable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Task;
import org.gradle.api.internal.tasks.AbstractTaskDependency;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.internal.tasks.TaskResolver;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.util.GUtil;
import org.gradle.util.UncheckedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTaskDependency
extends AbstractTaskDependency {
    private static final TaskResolver FAILING_RESOLVER = new TaskResolver(){

        public Task resolveTask(Object path) {
            throw new IllegalArgumentException(String.format("Cannot convert %s to a task.", path));
        }
    };
    private final Set<Object> values = new HashSet<Object>();
    private final TaskResolver resolver;

    public DefaultTaskDependency() {
        this(null);
    }

    public DefaultTaskDependency(TaskResolver resolver) {
        this.resolver = resolver == null ? FAILING_RESOLVER : resolver;
    }

    @Override
    public void resolve(TaskDependencyResolveContext context) {
        LinkedList<Object> queue = new LinkedList<Object>(this.values);
        while (!queue.isEmpty()) {
            Object dependency = queue.removeFirst();
            if (dependency instanceof Buildable) {
                context.add(dependency);
                continue;
            }
            if (dependency instanceof Task) {
                context.add(dependency);
                continue;
            }
            if (dependency instanceof TaskDependency) {
                context.add(dependency);
                continue;
            }
            if (dependency instanceof Closure) {
                Closure closure = (Closure)dependency;
                Object closureResult = closure.call((Object)context.getTask());
                if (closureResult == null) continue;
                queue.add(0, closureResult);
                continue;
            }
            if (dependency instanceof Iterable) {
                Iterable iterable = (Iterable)dependency;
                queue.addAll(0, GUtil.addToCollection(new ArrayList(), iterable));
                continue;
            }
            if (dependency instanceof Map) {
                Map map = (Map)dependency;
                queue.addAll(0, map.values());
                continue;
            }
            if (dependency instanceof Object[]) {
                Object[] array = (Object[])dependency;
                queue.addAll(0, Arrays.asList(array));
                continue;
            }
            if (dependency instanceof Callable) {
                Object callableResult;
                Callable callable = (Callable)dependency;
                try {
                    callableResult = callable.call();
                }
                catch (Exception e) {
                    throw UncheckedException.asUncheckedException(e);
                }
                if (callableResult == null) continue;
                queue.add(0, callableResult);
                continue;
            }
            context.add(this.resolver.resolveTask(dependency));
        }
    }

    public Set<Object> getValues() {
        return this.values;
    }

    public void setValues(Iterable<?> values) {
        this.values.clear();
        for (Object value : values) {
            this.addValue(value);
        }
    }

    public DefaultTaskDependency add(Object ... values) {
        for (Object value : values) {
            this.addValue(value);
        }
        return this;
    }

    private void addValue(Object dependency) {
        if (dependency == null) {
            throw new InvalidUserDataException("A dependency must not be empty");
        }
        this.values.add(dependency);
    }
}

