/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import groovy.lang.Closure;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.UnknownTaskException;
import org.gradle.api.internal.ClassGenerator;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.taskfactory.ITaskFactory;
import org.gradle.api.internal.tasks.DefaultTaskCollection;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTaskContainer
extends DefaultTaskCollection<Task>
implements TaskContainerInternal {
    private final ITaskFactory taskFactory;

    public DefaultTaskContainer(ProjectInternal project, ClassGenerator classGenerator, ITaskFactory taskFactory) {
        super(Task.class, classGenerator, project);
        this.taskFactory = taskFactory;
    }

    @Override
    public Task add(Map<String, ?> options) {
        HashMap mutableOptions = new HashMap(options);
        Object replaceStr = mutableOptions.remove("overwrite");
        boolean replace = replaceStr != null && "true".equals(replaceStr.toString());
        TaskInternal task = this.taskFactory.createTask(this.project, mutableOptions);
        String name = task.getName();
        if (!replace && this.findByNameWithoutRules(name) != null) {
            throw new InvalidUserDataException(String.format("Cannot add %s as a task with that name already exists.", task));
        }
        this.addObject(name, task);
        return task;
    }

    @Override
    public Task add(Map<String, ?> options, Closure configureClosure) throws InvalidUserDataException {
        return this.add(options).configure(configureClosure);
    }

    @Override
    public <T extends Task> T add(String name, Class<T> type) {
        return (T)((Task)type.cast(this.add(GUtil.map("name", name, "type", type))));
    }

    @Override
    public Task add(String name) {
        return this.add(GUtil.map("name", name));
    }

    @Override
    public Task replace(String name) {
        return this.add(GUtil.map("name", name, "overwrite", true));
    }

    @Override
    public Task add(String name, Closure configureClosure) {
        return this.add(GUtil.map("name", name)).configure(configureClosure);
    }

    @Override
    public <T extends Task> T replace(String name, Class<T> type) {
        return (T)((Task)type.cast(this.add(GUtil.map("name", name, "type", type, "overwrite", true))));
    }

    @Override
    public Task findByPath(String path) {
        if (!GUtil.isTrue(path)) {
            throw new InvalidUserDataException("A path must be specified!");
        }
        if (!path.contains(":")) {
            return (Task)this.findByName(path);
        }
        String projectPath = StringUtils.substringBeforeLast((String)path, (String)":");
        Project project = this.project.findProject(!GUtil.isTrue(projectPath) ? ":" : projectPath);
        if (project == null) {
            return null;
        }
        return (Task)project.getTasks().findByName(StringUtils.substringAfterLast((String)path, (String)":"));
    }

    @Override
    public Task resolveTask(Object path) {
        if (!GUtil.isTrue(path)) {
            throw new InvalidUserDataException("A path must be specified!");
        }
        return this.getByPath(path.toString());
    }

    @Override
    public Task getByPath(String path) throws UnknownTaskException {
        Task task = this.findByPath(path);
        if (task == null) {
            throw new UnknownTaskException(String.format("Task with path '%s' not found in %s.", path, this.project));
        }
        return task;
    }
}

