/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.resource;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URI;
import org.apache.commons.io.IOUtils;
import org.gradle.api.internal.resource.Resource;
import org.gradle.api.internal.resource.ResourceException;
import org.gradle.api.internal.resource.ResourceNotFoundException;
import org.gradle.util.GFileUtils;

public class UriResource
implements Resource {
    private final File sourceFile;
    private final URI sourceUri;
    private final String description;

    public UriResource(String description, File sourceFile) {
        this.description = description;
        this.sourceFile = GFileUtils.canonicalise(sourceFile);
        this.sourceUri = sourceFile.toURI();
    }

    public UriResource(String description, URI sourceUri) {
        this.description = description;
        this.sourceFile = sourceUri.getScheme().equals("file") ? GFileUtils.canonicalise(new File(sourceUri.getPath())) : null;
        this.sourceUri = sourceUri;
    }

    public String getDisplayName() {
        return String.format("%s '%s'", this.description, this.sourceFile != null ? this.sourceFile.getAbsolutePath() : this.sourceUri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getText() {
        String string;
        if (this.sourceFile != null && this.sourceFile.isDirectory()) {
            throw new ResourceException(String.format("Could not read %s as it is a directory.", this.getDisplayName()));
        }
        InputStream inputStream = this.sourceUri.toURL().openStream();
        try {
            string = IOUtils.toString((InputStream)inputStream);
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
                throw throwable;
            }
            catch (FileNotFoundException e) {
                throw new ResourceNotFoundException(String.format(String.format("Could not read %s as it does not exist.", this.getDisplayName()), new Object[0]));
            }
            catch (Exception e) {
                throw new ResourceException(String.format("Could not read %s.", this.getDisplayName()), e);
            }
        }
        inputStream.close();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getExists() {
        boolean bl;
        InputStream inputStream = this.sourceUri.toURL().openStream();
        try {
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                inputStream.close();
                throw throwable;
            }
            catch (FileNotFoundException e) {
                return false;
            }
            catch (Exception e) {
                throw new ResourceException(String.format("Could not determine if %s exists.", this.getDisplayName()), e);
            }
        }
        inputStream.close();
        return bl;
    }

    public File getFile() {
        return this.sourceFile;
    }

    public URI getURI() {
        return this.sourceUri;
    }
}

