/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.taskfactory;

import java.io.File;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Task;
import org.gradle.api.internal.project.taskfactory.PropertyActionContext;
import org.gradle.api.internal.project.taskfactory.PropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.UpdateAction;
import org.gradle.api.internal.project.taskfactory.ValidationAction;
import org.gradle.api.tasks.OutputFile;
import org.gradle.util.GFileUtils;
import org.gradle.util.UncheckedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputFilePropertyAnnotationHandler
implements PropertyAnnotationHandler {
    private final ValidationAction ouputFileValidation = new ValidationAction(){

        @Override
        public void validate(String propertyName, Object value, Collection<String> messages) {
            File fileValue = GFileUtils.canonicalise((File)value);
            if (fileValue.exists() && fileValue.isDirectory()) {
                messages.add(String.format("Cannot write to file '%s' specified for property '%s' as it is a directory.", fileValue, propertyName));
            }
            for (File candidate = fileValue.getParentFile(); candidate != null && !candidate.isDirectory(); candidate = candidate.getParentFile()) {
                if (!candidate.exists() || candidate.isDirectory()) continue;
                messages.add(String.format("Cannot write to file '%s' specified for property '%s', as ancestor '%s' is not a directory.", fileValue, propertyName, candidate));
                break;
            }
        }
    };

    @Override
    public Class<? extends Annotation> getAnnotationType() {
        return OutputFile.class;
    }

    @Override
    public void attachActions(final PropertyActionContext context) {
        context.setValidationAction(this.ouputFileValidation);
        context.setConfigureAction(new UpdateAction(){

            @Override
            public void update(Task task, final Callable<Object> futureValue) {
                task.getOutputs().files(futureValue);
                task.doFirst((Action<? super Task>)new Action<Task>(){

                    @Override
                    public void execute(Task task) {
                        File fileValue;
                        try {
                            fileValue = (File)futureValue.call();
                        }
                        catch (Exception e) {
                            throw UncheckedException.asUncheckedException(e);
                        }
                        if (fileValue == null) {
                            return;
                        }
                        if (!(fileValue = GFileUtils.canonicalise(fileValue)).getParentFile().isDirectory() && !fileValue.getParentFile().mkdirs()) {
                            throw new InvalidUserDataException(String.format("Cannot create parent directory '%s' of file specified for property '%s'.", fileValue.getParentFile(), context.getName()));
                        }
                    }
                });
            }
        });
    }
}

