/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.taskfactory;

import java.io.File;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Task;
import org.gradle.api.internal.project.taskfactory.PropertyActionContext;
import org.gradle.api.internal.project.taskfactory.PropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.UpdateAction;
import org.gradle.api.internal.project.taskfactory.ValidationAction;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.util.GFileUtils;
import org.gradle.util.UncheckedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputDirectoryPropertyAnnotationHandler
implements PropertyAnnotationHandler {
    private final ValidationAction outputDirValidation = new ValidationAction(){

        @Override
        public void validate(String propertyName, Object value, Collection<String> messages) {
            File fileValue = (File)value;
            if (fileValue.exists() && !fileValue.isDirectory()) {
                messages.add(String.format("Directory '%s' specified for property '%s' is not a directory.", fileValue, propertyName));
                return;
            }
            for (File candidate = fileValue; candidate != null && !candidate.isDirectory(); candidate = candidate.getParentFile()) {
                if (!candidate.exists() || candidate.isDirectory()) continue;
                messages.add(String.format("Cannot write to directory '%s' specified for property '%s', as ancestor '%s' is not a directory.", fileValue, propertyName, candidate));
                break;
            }
        }
    };

    @Override
    public Class<? extends Annotation> getAnnotationType() {
        return OutputDirectory.class;
    }

    @Override
    public void attachActions(final PropertyActionContext context) {
        context.setValidationAction(this.outputDirValidation);
        context.setConfigureAction(new UpdateAction(){

            @Override
            public void update(Task task, final Callable<Object> futureValue) {
                task.getOutputs().files(futureValue);
                task.doFirst((Action<? super Task>)new Action<Task>(){

                    @Override
                    public void execute(Task task) {
                        File fileValue;
                        try {
                            fileValue = (File)futureValue.call();
                        }
                        catch (Exception e) {
                            throw UncheckedException.asUncheckedException(e);
                        }
                        if (fileValue == null) {
                            return;
                        }
                        if (!(fileValue = GFileUtils.canonicalise(fileValue)).isDirectory() && !fileValue.mkdirs()) {
                            throw new InvalidUserDataException(String.format("Cannot create directory '%s' specified for property '%s'.", fileValue, context.getName()));
                        }
                    }
                });
            }
        });
    }
}

