/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.taskfactory;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Task;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.taskfactory.ITaskFactory;
import org.gradle.api.internal.project.taskfactory.InputDirectoryPropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.InputFilePropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.InputFilesPropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.InputPropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.NestedBeanPropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.OutputDirectoryPropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.OutputFilePropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.PropertyActionContext;
import org.gradle.api.internal.project.taskfactory.PropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.UpdateAction;
import org.gradle.api.internal.project.taskfactory.ValidationAction;
import org.gradle.api.internal.tasks.execution.TaskValidator;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.util.ReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationProcessingTaskFactory
implements ITaskFactory {
    private final ITaskFactory taskFactory;
    private final Map<Class, List<Action<Task>>> actionsForType = new HashMap<Class, List<Action<Task>>>();
    private final List<? extends PropertyAnnotationHandler> handlers = Arrays.asList(new InputFilePropertyAnnotationHandler(), new InputDirectoryPropertyAnnotationHandler(), new InputFilesPropertyAnnotationHandler(), new OutputFilePropertyAnnotationHandler(), new OutputDirectoryPropertyAnnotationHandler(), new InputPropertyAnnotationHandler(), new NestedBeanPropertyAnnotationHandler());
    private final ValidationAction notNullValidator = new ValidationAction(){

        @Override
        public void validate(String propertyName, Object value, Collection<String> messages) {
            if (value == null) {
                messages.add(String.format("No value has been specified for property '%s'.", propertyName));
            }
        }
    };

    public AnnotationProcessingTaskFactory(ITaskFactory taskFactory) {
        this.taskFactory = taskFactory;
    }

    @Override
    public TaskInternal createTask(ProjectInternal project, Map<String, ?> args) {
        TaskInternal task = this.taskFactory.createTask(project, args);
        Class<?> type = task.getClass();
        List<Action<Task>> actions = this.actionsForType.get(type);
        if (actions == null) {
            actions = this.createActionsForType(type);
            this.actionsForType.put(type, actions);
        }
        for (Action<Task> action : actions) {
            task.doFirst(action);
            if (!(action instanceof Validator)) continue;
            Validator validator = (Validator)action;
            validator.addInputsAndOutputs(task);
        }
        return task;
    }

    private List<Action<Task>> createActionsForType(Class<? extends Task> type) {
        ArrayList<Action<Task>> actions = new ArrayList<Action<Task>>();
        this.findTaskActions(type, actions);
        this.findProperties(type, actions);
        return actions;
    }

    private void findProperties(Class<? extends Task> type, List<Action<Task>> actions) {
        Validator validator = new Validator();
        validator.attachActions(null, type);
        if (!validator.properties.isEmpty()) {
            actions.add(validator);
        }
    }

    private void findTaskActions(Class<? extends Task> type, List<Action<Task>> actions) {
        HashSet<String> methods = new HashSet<String>();
        for (Class<? extends Task> current = type; current != null; current = current.getSuperclass()) {
            for (Method method : current.getDeclaredMethods()) {
                this.attachTaskAction(method, actions, methods);
            }
        }
    }

    private void attachTaskAction(final Method method, Collection<Action<Task>> actions, Collection<String> methods) {
        if (method.getAnnotation(TaskAction.class) == null) {
            return;
        }
        if (Modifier.isStatic(method.getModifiers())) {
            throw new GradleException(String.format("Cannot use @TaskAction annotation on static method %s.%s().", method.getDeclaringClass().getSimpleName(), method.getName()));
        }
        if (method.getParameterTypes().length > 0) {
            throw new GradleException(String.format("Cannot use @TaskAction annotation on method %s.%s() as this method takes parameters.", method.getDeclaringClass().getSimpleName(), method.getName()));
        }
        if (methods.contains(method.getName())) {
            return;
        }
        methods.add(method.getName());
        actions.add(new Action<Task>(){

            @Override
            public void execute(Task task) {
                ReflectionUtil.invoke(task, method.getName(), new Object[0]);
            }
        });
    }

    private static boolean isGetter(Method method) {
        return method.getName().startsWith("get") && method.getReturnType() != Void.TYPE && method.getParameterTypes().length == 0 && !Modifier.isStatic(method.getModifiers());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PropertyInfo
    implements PropertyActionContext {
        private static final ValidationAction NO_OP_VALIDATION_ACTION = new ValidationAction(){

            @Override
            public void validate(String propertyName, Object value, Collection<String> messages) {
            }
        };
        private static final PropertyValue NO_OP_VALUE = new PropertyValue(){

            @Override
            public Object getValue() {
                return null;
            }

            @Override
            public void checkNotNull(Collection<String> messages) {
            }

            @Override
            public void checkValid(Collection<String> messages) {
            }
        };
        private static final UpdateAction NO_OP_CONFIGURATION_ACTION = new UpdateAction(){

            @Override
            public void update(Task task, Callable<Object> futureValue) {
            }
        };
        private final Validator validator;
        private final PropertyInfo parent;
        private final String propertyName;
        private final Method method;
        private ValidationAction validationAction = NO_OP_VALIDATION_ACTION;
        private ValidationAction notNullValidator = NO_OP_VALIDATION_ACTION;
        private UpdateAction configureAction = NO_OP_CONFIGURATION_ACTION;
        public boolean required;

        private PropertyInfo(Validator validator, PropertyInfo parent, String propertyName, Method method) {
            this.validator = validator;
            this.parent = parent;
            this.propertyName = propertyName;
            this.method = method;
        }

        public String toString() {
            return this.propertyName;
        }

        @Override
        public String getName() {
            return this.propertyName;
        }

        @Override
        public Class<?> getType() {
            return this.method.getReturnType();
        }

        @Override
        public AnnotatedElement getTarget() {
            return this.method;
        }

        @Override
        public void setValidationAction(ValidationAction action) {
            this.validationAction = action;
        }

        @Override
        public void setConfigureAction(UpdateAction action) {
            this.configureAction = action;
        }

        public void setNotNullValidator(ValidationAction notNullValidator) {
            this.notNullValidator = notNullValidator;
        }

        @Override
        public void attachActions(Class<?> type) {
            this.validator.attachActions(this, type);
        }

        public PropertyValue getValue(Object rootObject) {
            Object bean = rootObject;
            if (this.parent != null) {
                PropertyValue parentValue = this.parent.getValue(rootObject);
                if (parentValue.getValue() == null) {
                    return NO_OP_VALUE;
                }
                bean = parentValue.getValue();
            }
            final Object value = ReflectionUtil.invoke(bean, this.method.getName(), new Object[0]);
            return new PropertyValue(){

                @Override
                public Object getValue() {
                    return value;
                }

                @Override
                public void checkNotNull(Collection<String> messages) {
                    PropertyInfo.this.notNullValidator.validate(PropertyInfo.this.propertyName, value, messages);
                }

                @Override
                public void checkValid(Collection<String> messages) {
                    if (value != null) {
                        PropertyInfo.this.validationAction.validate(PropertyInfo.this.propertyName, value, messages);
                    }
                }
            };
        }

        public void attachActions(PropertyAnnotationHandler handler) {
            handler.attachActions(this);
            this.required = true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface PropertyValue {
        public Object getValue();

        public void checkNotNull(Collection<String> var1);

        public void checkValid(Collection<String> var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Validator
    implements Action<Task>,
    TaskValidator {
        private Set<PropertyInfo> properties = new LinkedHashSet<PropertyInfo>();

        private Validator() {
        }

        public void addInputsAndOutputs(final TaskInternal task) {
            task.addValidator(this);
            for (final PropertyInfo property : this.properties) {
                Callable<Object> futureValue = new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return property.getValue(task).getValue();
                    }
                };
                property.configureAction.update(task, futureValue);
            }
        }

        @Override
        public void execute(Task task) {
        }

        @Override
        public void validate(TaskInternal task, Collection<String> messages) {
            ArrayList<PropertyValue> propertyValues = new ArrayList<PropertyValue>();
            for (PropertyInfo property : this.properties) {
                propertyValues.add(property.getValue(task));
            }
            for (PropertyValue propertyValue : propertyValues) {
                propertyValue.checkNotNull(messages);
            }
            for (PropertyValue propertyValue : propertyValues) {
                propertyValue.checkValid(messages);
            }
        }

        public void attachActions(PropertyInfo parent, Class<?> type) {
            if (type.getSuperclass() != null) {
                this.attachActions(parent, type.getSuperclass());
            }
            for (Method method : type.getDeclaredMethods()) {
                String fieldName;
                if (!AnnotationProcessingTaskFactory.isGetter(method)) continue;
                String propertyName = fieldName = StringUtils.uncapitalize((String)method.getName().substring(3));
                if (parent != null) {
                    propertyName = parent.getName() + '.' + propertyName;
                }
                PropertyInfo propertyInfo = new PropertyInfo(this, parent, propertyName, method);
                this.attachValidationActions(propertyInfo, fieldName);
                if (!propertyInfo.required) continue;
                this.properties.add(propertyInfo);
            }
        }

        private void attachValidationActions(PropertyInfo propertyInfo, String fieldName) {
            for (PropertyAnnotationHandler handler : AnnotationProcessingTaskFactory.this.handlers) {
                this.attachValidationAction(handler, propertyInfo, fieldName);
            }
        }

        private void attachValidationAction(PropertyAnnotationHandler handler, PropertyInfo propertyInfo, String fieldName) {
            Method method = propertyInfo.method;
            Class<? extends Annotation> annotationType = handler.getAnnotationType();
            AccessibleObject annotationTarget = null;
            if (method.getAnnotation(annotationType) != null) {
                annotationTarget = method;
            } else {
                try {
                    Field field = method.getDeclaringClass().getDeclaredField(fieldName);
                    if (field.getAnnotation(annotationType) != null) {
                        annotationTarget = field;
                    }
                }
                catch (NoSuchFieldException e) {
                    // empty catch block
                }
            }
            if (annotationTarget == null) {
                return;
            }
            Optional optional = annotationTarget.getAnnotation(Optional.class);
            if (optional == null) {
                propertyInfo.setNotNullValidator(AnnotationProcessingTaskFactory.this.notNullValidator);
            }
            propertyInfo.attachActions(handler);
        }
    }
}

