/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project;

import java.io.File;
import org.gradle.api.initialization.ProjectDescriptor;
import org.gradle.api.internal.ClassGenerator;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.project.DefaultProject;
import org.gradle.api.internal.project.IProjectFactory;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.groovy.scripts.StringScriptSource;
import org.gradle.groovy.scripts.UriScriptSource;

public class ProjectFactory
implements IProjectFactory {
    private ScriptSource embeddedScript;
    private final ClassGenerator classGenerator;

    public ProjectFactory(ScriptSource embeddedScript, ClassGenerator classGenerator) {
        this.embeddedScript = embeddedScript;
        this.classGenerator = classGenerator;
    }

    public DefaultProject createProject(ProjectDescriptor projectDescriptor, ProjectInternal parent, GradleInternal gradle) {
        File buildFile = projectDescriptor.getBuildFile();
        ScriptSource source = this.embeddedScript != null ? this.embeddedScript : (!buildFile.exists() ? new StringScriptSource("empty build file", "") : new UriScriptSource("build file", buildFile));
        DefaultProject project = this.classGenerator.newInstance(DefaultProject.class, projectDescriptor.getName(), parent, projectDescriptor.getProjectDir(), source, gradle, gradle.getServices());
        if (parent != null) {
            parent.addChildProject(project);
        }
        gradle.getProjectRegistry().addProject(project);
        return project;
    }
}

