/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.copy;

import groovy.lang.Closure;
import java.io.FilterReader;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.gradle.api.Action;
import org.gradle.api.file.CopyProcessingSpec;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.copy.CopyAction;
import org.gradle.api.internal.file.copy.CopySpecImpl;
import org.gradle.api.internal.file.copy.CopySpecSource;
import org.gradle.api.internal.file.copy.CopySpecVisitor;
import org.gradle.api.internal.file.copy.MappingCopySpecVisitor;
import org.gradle.api.internal.file.copy.NormalizingCopySpecVisitor;
import org.gradle.api.internal.file.copy.ReadableCopySpec;
import org.gradle.api.specs.Spec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyActionImpl
implements CopyAction,
CopySpecSource {
    private final CopySpecVisitor visitor;
    private final CopySpecImpl root;
    private final CopySpecImpl mainContent;
    private final FileResolver resolver;

    public CopyActionImpl(FileResolver resolver, CopySpecVisitor visitor) {
        this.resolver = resolver;
        this.root = new CopySpecImpl(resolver);
        this.mainContent = this.root.addChild();
        this.visitor = new MappingCopySpecVisitor(new NormalizingCopySpecVisitor(visitor));
    }

    public FileResolver getResolver() {
        return this.resolver;
    }

    @Override
    public CopySpecImpl getRootSpec() {
        return this.root;
    }

    public CopySpecImpl getMainSpec() {
        return this.mainContent;
    }

    public void execute() {
        this.visitor.startVisit(this);
        for (ReadableCopySpec spec : this.root.getAllSpecs()) {
            this.visitor.visitSpec(spec);
            spec.getSource().visit(this.visitor);
        }
        this.visitor.endVisit();
    }

    @Override
    public boolean getDidWork() {
        return this.visitor.getDidWork();
    }

    public FileTree getAllSource() {
        ArrayList<FileTree> sources = new ArrayList<FileTree>();
        for (ReadableCopySpec spec : this.root.getAllSpecs()) {
            FileTree source = spec.getSource();
            sources.add(source);
        }
        return this.resolver.resolveFilesAsTree(sources);
    }

    public boolean hasSource() {
        return this.root.hasSource();
    }

    @Override
    public CopySpec eachFile(Action<? super FileCopyDetails> action) {
        this.mainContent.eachFile((Action)action);
        return this;
    }

    @Override
    public CopySpec eachFile(Closure closure) {
        this.mainContent.eachFile(closure);
        return this;
    }

    @Override
    public CopySpec exclude(Iterable<String> excludes) {
        this.mainContent.exclude((Iterable)excludes);
        return this;
    }

    @Override
    public CopySpec exclude(String ... excludes) {
        this.mainContent.exclude(excludes);
        return this;
    }

    @Override
    public CopySpec exclude(Closure excludeSpec) {
        this.mainContent.exclude(excludeSpec);
        return this;
    }

    @Override
    public CopySpec exclude(Spec<FileTreeElement> excludeSpec) {
        this.mainContent.exclude((Spec)excludeSpec);
        return this;
    }

    @Override
    public CopySpec expand(Map<String, ?> properties) {
        this.mainContent.expand((Map)properties);
        return this;
    }

    @Override
    public CopySpec filter(Closure closure) {
        this.mainContent.filter(closure);
        return this;
    }

    @Override
    public CopySpec filter(Class<? extends FilterReader> filterType) {
        this.mainContent.filter((Class)filterType);
        return this;
    }

    @Override
    public CopySpec filter(Map<String, ?> properties, Class<? extends FilterReader> filterType) {
        this.mainContent.filter((Map)properties, (Class)filterType);
        return this;
    }

    @Override
    public CopySpec from(Object sourcePath, Closure c) {
        return this.mainContent.from(sourcePath, c);
    }

    @Override
    public CopySpec from(Object ... sourcePaths) {
        this.mainContent.from(sourcePaths);
        return this;
    }

    @Override
    public Set<String> getExcludes() {
        return this.mainContent.getExcludes();
    }

    @Override
    public Set<String> getIncludes() {
        return this.mainContent.getIncludes();
    }

    @Override
    public CopySpec include(Iterable<String> includes) {
        this.mainContent.include((Iterable)includes);
        return this;
    }

    @Override
    public CopySpec include(String ... includes) {
        this.mainContent.include(includes);
        return this;
    }

    @Override
    public CopySpec include(Closure includeSpec) {
        this.mainContent.include(includeSpec);
        return this;
    }

    @Override
    public CopySpec include(Spec<FileTreeElement> includeSpec) {
        this.mainContent.include((Spec)includeSpec);
        return this;
    }

    @Override
    public CopySpec into(Object destDir) {
        this.mainContent.into(destDir);
        return this;
    }

    @Override
    public CopySpec into(Object destPath, Closure configureClosure) {
        return this.mainContent.into(destPath, configureClosure);
    }

    @Override
    public boolean isCaseSensitive() {
        return this.mainContent.isCaseSensitive();
    }

    @Override
    public boolean getIncludeEmptyDirs() {
        return this.mainContent.getIncludeEmptyDirs();
    }

    @Override
    public void setIncludeEmptyDirs(boolean includeEmptyDirs) {
        this.mainContent.setIncludeEmptyDirs(includeEmptyDirs);
    }

    @Override
    public CopySpec rename(Closure closure) {
        this.mainContent.rename(closure);
        return this;
    }

    @Override
    public CopySpec rename(Pattern sourceRegEx, String replaceWith) {
        this.mainContent.rename(sourceRegEx, replaceWith);
        return this;
    }

    @Override
    public CopySpec rename(String sourceRegEx, String replaceWith) {
        this.mainContent.rename(sourceRegEx, replaceWith);
        return this;
    }

    @Override
    public void setCaseSensitive(boolean caseSensitive) {
        this.mainContent.setCaseSensitive(caseSensitive);
    }

    @Override
    public int getDirMode() {
        return this.mainContent.getDirMode();
    }

    @Override
    public CopyProcessingSpec setDirMode(int mode) {
        this.mainContent.setDirMode(mode);
        return this;
    }

    @Override
    public CopySpec setExcludes(Iterable<String> excludes) {
        this.mainContent.setExcludes((Iterable)excludes);
        return this;
    }

    @Override
    public int getFileMode() {
        return this.mainContent.getFileMode();
    }

    @Override
    public CopyProcessingSpec setFileMode(int mode) {
        this.mainContent.setFileMode(mode);
        return this;
    }

    @Override
    public CopySpec setIncludes(Iterable<String> includes) {
        this.mainContent.setIncludes((Iterable)includes);
        return this;
    }

    @Override
    public CopySpec with(CopySpec ... copySpecs) {
        this.mainContent.with(copySpecs);
        return this;
    }
}

