/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.collections;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.internal.file.collections.MinimalFileSet;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListBackedFileSet
implements MinimalFileSet {
    private final Set<File> files;

    public ListBackedFileSet(File ... files) {
        this(Arrays.asList(files));
    }

    public ListBackedFileSet(Collection<File> files) {
        this.files = new LinkedHashSet<File>(files);
    }

    @Override
    public String getDisplayName() {
        switch (this.files.size()) {
            case 0: {
                return "empty file collection";
            }
            case 1: {
                return String.format("file '%s'", this.files.iterator().next());
            }
        }
        return String.format("files %s", GUtil.toString(this.files));
    }

    @Override
    public Set<File> getFiles() {
        return this.files;
    }
}

