/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.archive;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.AbstractFileTreeElement;
import org.gradle.api.internal.file.collections.DirectoryFileTree;
import org.gradle.api.internal.file.collections.FileSystemMirroringFileTree;
import org.gradle.api.internal.file.collections.MinimalFileTree;
import org.gradle.util.GFileUtils;
import org.gradle.util.HashUtil;

public class TarFileTree
implements MinimalFileTree,
FileSystemMirroringFileTree {
    private final File tarFile;
    private final File tmpDir;

    public TarFileTree(File tarFile, File tmpDir) {
        this.tarFile = tarFile;
        String expandDirName = String.format("%s_%s", tarFile.getName(), HashUtil.createHash(tarFile.getAbsolutePath()));
        this.tmpDir = new File(tmpDir, expandDirName);
    }

    public String getDisplayName() {
        return String.format("TAR '%s'", this.tarFile);
    }

    public DirectoryFileTree getMirror() {
        return new DirectoryFileTree(this.tmpDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visit(FileVisitor visitor) {
        if (!this.tarFile.exists()) {
            return;
        }
        if (!this.tarFile.isFile()) {
            throw new InvalidUserDataException(String.format("Cannot expand %s as it is not a file.", this.getDisplayName()));
        }
        AtomicBoolean stopFlag = new AtomicBoolean();
        try {
            FileInputStream inputStream = new FileInputStream(this.tarFile);
            try {
                TarEntry entry;
                NoCloseTarInputStream tar = new NoCloseTarInputStream(inputStream);
                while (!stopFlag.get() && (entry = tar.getNextEntry()) != null) {
                    if (entry.isDirectory()) {
                        visitor.visitDir(new DetailsImpl(entry, tar, stopFlag));
                        continue;
                    }
                    visitor.visitFile(new DetailsImpl(entry, tar, stopFlag));
                }
            }
            finally {
                inputStream.close();
            }
        }
        catch (Exception e) {
            throw new GradleException(String.format("Could not expand %s.", this.getDisplayName()), e);
        }
    }

    private static class NoCloseTarInputStream
    extends TarInputStream {
        public NoCloseTarInputStream(InputStream is) {
            super(is);
        }

        public void close() throws IOException {
        }

        public TarEntry getCurrent() {
            return this.currEntry;
        }
    }

    private class DetailsImpl
    extends AbstractFileTreeElement
    implements FileVisitDetails {
        private final TarEntry entry;
        private final NoCloseTarInputStream tar;
        private final AtomicBoolean stopFlag;
        private File file;
        private boolean read;

        public DetailsImpl(TarEntry entry, NoCloseTarInputStream tar, AtomicBoolean stopFlag) {
            this.entry = entry;
            this.tar = tar;
            this.stopFlag = stopFlag;
        }

        public String getDisplayName() {
            return String.format("tar entry %s!%s", TarFileTree.this.tarFile, this.entry.getName());
        }

        public void stopVisiting() {
            this.stopFlag.set(true);
        }

        public File getFile() {
            if (this.file == null) {
                this.file = new File(TarFileTree.this.tmpDir, this.entry.getName());
                this.copyTo(this.file);
            }
            return this.file;
        }

        public long getLastModified() {
            return this.entry.getModTime().getTime();
        }

        public boolean isDirectory() {
            return this.entry.isDirectory();
        }

        public long getSize() {
            return this.entry.getSize();
        }

        public InputStream open() {
            if (this.read && this.file != null) {
                return GFileUtils.openInputStream(this.file);
            }
            if (this.read || this.tar.getCurrent() != this.entry) {
                throw new UnsupportedOperationException(String.format("The contents of %s has already been read.", this));
            }
            this.read = true;
            return this.tar;
        }

        public RelativePath getRelativePath() {
            return new RelativePath(!this.entry.isDirectory(), this.entry.getName().split("/"));
        }
    }
}

