/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.archive;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.tools.bzip2.CBZip2OutputStream;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarOutputStream;
import org.gradle.api.GradleException;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.internal.file.archive.TarCopyAction;
import org.gradle.api.internal.file.copy.CopyAction;
import org.gradle.api.internal.file.copy.EmptyCopySpecVisitor;
import org.gradle.api.internal.file.copy.ReadableCopySpec;

public class TarCopySpecVisitor
extends EmptyCopySpecVisitor {
    private TarOutputStream tarOutStr;
    private File tarFile;
    private ReadableCopySpec spec;

    public void startVisit(CopyAction action) {
        TarCopyAction archiveAction = (TarCopyAction)action;
        try {
            this.tarFile = archiveAction.getArchivePath();
            OutputStream outStr = new FileOutputStream(this.tarFile);
            switch (archiveAction.getCompression()) {
                case GZIP: {
                    outStr = new GZIPOutputStream(outStr);
                    break;
                }
                case BZIP2: {
                    ((OutputStream)outStr).write(66);
                    ((OutputStream)outStr).write(90);
                    outStr = new CBZip2OutputStream(outStr);
                }
            }
            this.tarOutStr = new TarOutputStream(outStr);
            this.tarOutStr.setLongFileMode(2);
        }
        catch (Exception e) {
            throw new GradleException(String.format("Could not create TAR '%s'.", this.tarFile), e);
        }
    }

    public void endVisit() {
        try {
            this.tarOutStr.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            this.tarOutStr = null;
            this.spec = null;
        }
    }

    public void visitSpec(ReadableCopySpec spec) {
        this.spec = spec;
    }

    public void visitFile(FileVisitDetails fileDetails) {
        try {
            TarEntry archiveEntry = new TarEntry(fileDetails.getRelativePath().getPathString());
            archiveEntry.setModTime(fileDetails.getLastModified());
            archiveEntry.setSize(fileDetails.getSize());
            archiveEntry.setMode(0x8000 | this.spec.getFileMode());
            this.tarOutStr.putNextEntry(archiveEntry);
            fileDetails.copyTo((OutputStream)this.tarOutStr);
            this.tarOutStr.closeEntry();
        }
        catch (Exception e) {
            throw new GradleException(String.format("Could not add %s to TAR '%s'.", fileDetails, this.tarFile), e);
        }
    }

    public void visitDir(FileVisitDetails dirDetails) {
        try {
            TarEntry archiveEntry = new TarEntry(dirDetails.getRelativePath().getPathString() + '/');
            archiveEntry.setModTime(dirDetails.getLastModified());
            archiveEntry.setMode(0x4000 | this.spec.getDirMode());
            this.tarOutStr.putNextEntry(archiveEntry);
            this.tarOutStr.closeEntry();
        }
        catch (Exception e) {
            throw new GradleException(String.format("Could not add %s to TAR '%s'.", dirDetails, this.tarFile), e);
        }
    }

    public boolean getDidWork() {
        return true;
    }
}

