/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import groovy.lang.Closure;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.PathValidation;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.file.BaseDirConverter;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.FileSource;
import org.gradle.api.internal.file.collections.DefaultConfigurableFileCollection;
import org.gradle.util.GFileUtils;
import org.gradle.util.OperatingSystem;

public abstract class AbstractFileResolver
implements FileResolver {
    private static final Pattern URI_SCHEME = Pattern.compile("[a-zA-Z][a-zA-Z0-9+-\\.]*:.+");
    private static final Pattern ENCODED_URI = Pattern.compile("%([0-9a-fA-F]{2})");

    public FileResolver withBaseDir(Object path) {
        return new BaseDirConverter(this.resolve(path));
    }

    public File resolve(Object path) {
        return this.resolve(path, PathValidation.NONE);
    }

    public File resolve(Object path, PathValidation validation) {
        File file = this.doResolve(path);
        file = GFileUtils.canonicalise(file);
        this.validate(file, validation);
        return file;
    }

    public FileSource resolveLater(final Object path) {
        return new FileSource(){

            public File get() {
                return AbstractFileResolver.this.resolve(path);
            }
        };
    }

    public URI resolveUri(Object path) {
        return this.convertObjectToURI(path);
    }

    protected abstract File doResolve(Object var1);

    protected URI convertObjectToURI(Object path) {
        Object object = this.unpack(path);
        Object converted = this.convertToFileOrUri(object);
        if (converted instanceof File) {
            return this.resolve(converted).toURI();
        }
        return (URI)converted;
    }

    protected File convertObjectToFile(Object path) {
        Object object = this.unpack(path);
        if (object == null) {
            return null;
        }
        Object converted = this.convertToFileOrUri(object);
        if (converted instanceof File) {
            return (File)converted;
        }
        throw new InvalidUserDataException(String.format("Cannot convert URL '%s' to a file.", converted));
    }

    private Object convertToFileOrUri(Object path) {
        if (path instanceof File) {
            return path;
        }
        if (path instanceof URL) {
            try {
                path = ((URL)path).toURI();
            }
            catch (URISyntaxException e) {
                throw new UncheckedIOException(e);
            }
        }
        if (path instanceof URI) {
            URI uri = (URI)path;
            if (uri.getScheme().equals("file")) {
                return new File(uri.getPath());
            }
            return uri;
        }
        String str = path.toString();
        if (str.startsWith("file:")) {
            return new File(this.uriDecode(str.substring(5)));
        }
        for (File file : File.listRoots()) {
            String rootPath = file.getAbsolutePath();
            String normalisedStr = str;
            if (!OperatingSystem.current().isCaseSensitiveFileSystem()) {
                rootPath = rootPath.toLowerCase();
                normalisedStr = normalisedStr.toLowerCase();
            }
            if (!normalisedStr.startsWith(rootPath) && !normalisedStr.startsWith(rootPath.replace(File.separatorChar, '/'))) continue;
            return new File(str);
        }
        if (URI_SCHEME.matcher(str).matches()) {
            try {
                return new URI(str);
            }
            catch (URISyntaxException e) {
                throw new UncheckedIOException(e);
            }
        }
        return new File(str);
    }

    private String uriDecode(String path) {
        StringBuffer builder = new StringBuffer();
        Matcher matcher = ENCODED_URI.matcher(path);
        while (matcher.find()) {
            String val = matcher.group(1);
            matcher.appendReplacement(builder, String.valueOf((char)Integer.parseInt(val, 16)));
        }
        matcher.appendTail(builder);
        return builder.toString();
    }

    private Object unpack(Object path) {
        Object current = path;
        while (current != null) {
            if (current instanceof Closure) {
                current = ((Closure)current).call();
                continue;
            }
            if (current instanceof Callable) {
                try {
                    current = ((Callable)current).call();
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            if (current instanceof FileSource) {
                return ((FileSource)current).get();
            }
            return current;
        }
        return null;
    }

    protected void validate(File file, PathValidation validation) {
        switch (validation) {
            case NONE: {
                break;
            }
            case EXISTS: {
                if (file.exists()) break;
                throw new InvalidUserDataException(String.format("File '%s' does not exist.", file));
            }
            case FILE: {
                if (!file.exists()) {
                    throw new InvalidUserDataException(String.format("File '%s' does not exist.", file));
                }
                if (file.isFile()) break;
                throw new InvalidUserDataException(String.format("File '%s' is not a file.", file));
            }
            case DIRECTORY: {
                if (!file.exists()) {
                    throw new InvalidUserDataException(String.format("Directory '%s' does not exist.", file));
                }
                if (file.isDirectory()) break;
                throw new InvalidUserDataException(String.format("Directory '%s' is not a directory.", file));
            }
        }
    }

    public FileCollection resolveFiles(Object ... paths) {
        if (paths.length == 1 && paths[0] instanceof FileCollection) {
            return (FileCollection)paths[0];
        }
        return new DefaultConfigurableFileCollection(this, null, paths);
    }

    public FileTree resolveFilesAsTree(Object ... paths) {
        return this.resolveFiles(paths).getAsFileTree();
    }
}

