/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import groovy.lang.Closure;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.file.AntFileCollectionBuilder;
import org.gradle.api.internal.file.AntFileCollectionMatchingTaskBuilder;
import org.gradle.api.internal.file.AntFileSetBuilder;
import org.gradle.api.internal.file.CompositeFileTree;
import org.gradle.api.internal.file.UnionFileCollection;
import org.gradle.api.internal.file.collections.DirectoryFileTree;
import org.gradle.api.internal.file.collections.FileCollectionResolveContext;
import org.gradle.api.internal.file.collections.MinimalFileSet;
import org.gradle.api.internal.file.collections.ResolvableFileCollectionResolveContext;
import org.gradle.api.internal.tasks.DefaultTaskDependency;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.api.tasks.StopExecutionException;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFileCollection
implements FileCollection,
MinimalFileSet {
    @Override
    public abstract String getDisplayName();

    public String toString() {
        return this.getDisplayName();
    }

    @Override
    public File getSingleFile() throws IllegalStateException {
        Set<File> files = this.getFiles();
        if (files.isEmpty()) {
            throw new IllegalStateException(String.format("Expected %s to contain exactly one file, however, it contains no files.", this.getDisplayName()));
        }
        if (files.size() != 1) {
            throw new IllegalStateException(String.format("Expected %s to contain exactly one file, however, it contains %d files.", this.getDisplayName(), files.size()));
        }
        return (File)files.iterator().next();
    }

    @Override
    public Iterator<File> iterator() {
        return this.getFiles().iterator();
    }

    @Override
    public String getAsPath() {
        return GUtil.join(this.getFiles(), File.pathSeparator);
    }

    @Override
    public boolean contains(File file) {
        return this.getFiles().contains(file);
    }

    @Override
    public FileCollection plus(FileCollection collection) {
        return new UnionFileCollection(this, collection);
    }

    @Override
    public FileCollection minus(final FileCollection collection) {
        return new AbstractFileCollection(){

            @Override
            public String getDisplayName() {
                return AbstractFileCollection.this.getDisplayName();
            }

            @Override
            public TaskDependency getBuildDependencies() {
                return AbstractFileCollection.this.getBuildDependencies();
            }

            @Override
            public Set<File> getFiles() {
                LinkedHashSet<File> files = new LinkedHashSet<File>(AbstractFileCollection.this.getFiles());
                files.removeAll(collection.getFiles());
                return files;
            }
        };
    }

    @Override
    public FileCollection add(FileCollection collection) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(String.format("%s does not allow modification.", this.getCapDisplayName()));
    }

    @Override
    public void addToAntBuilder(Object builder, String nodeName, FileCollection.AntType type) {
        if (type == FileCollection.AntType.ResourceCollection) {
            this.addAsResourceCollection(builder, nodeName);
        } else if (type == FileCollection.AntType.FileSet) {
            this.addAsFileSet(builder, nodeName);
        } else {
            this.addAsMatchingTask(builder, nodeName);
        }
    }

    protected void addAsMatchingTask(Object builder, String nodeName) {
        new AntFileCollectionMatchingTaskBuilder(this.getAsFileTrees()).addToAntBuilder(builder, nodeName);
    }

    protected void addAsFileSet(Object builder, String nodeName) {
        new AntFileSetBuilder(this.getAsFileTrees()).addToAntBuilder(builder, nodeName);
    }

    protected void addAsResourceCollection(Object builder, String nodeName) {
        new AntFileCollectionBuilder(this).addToAntBuilder(builder, nodeName);
    }

    protected Collection<DirectoryFileTree> getAsFileTrees() {
        ArrayList<DirectoryFileTree> fileTrees = new ArrayList<DirectoryFileTree>();
        for (File file : this.getFiles()) {
            if (!file.isFile()) continue;
            PatternSet patternSet = new PatternSet();
            patternSet.include(file.getName());
            fileTrees.add(new DirectoryFileTree(file.getParentFile(), patternSet));
        }
        return fileTrees;
    }

    @Override
    public Object addToAntBuilder(Object node, String childNodeName) {
        this.addToAntBuilder(node, childNodeName, FileCollection.AntType.ResourceCollection);
        return this;
    }

    @Override
    public boolean isEmpty() {
        return this.getFiles().isEmpty();
    }

    @Override
    public FileCollection stopExecutionIfEmpty() {
        if (this.isEmpty()) {
            throw new StopExecutionException(String.format("%s does not contain any files.", this.getCapDisplayName()));
        }
        return this;
    }

    @Override
    public Object asType(Class<?> type) throws UnsupportedOperationException {
        if (type.isAssignableFrom(Set.class)) {
            return this.getFiles();
        }
        if (type.isAssignableFrom(List.class)) {
            return new ArrayList<File>(this.getFiles());
        }
        if (type.isAssignableFrom(File[].class)) {
            Set<File> files = this.getFiles();
            return files.toArray(new File[files.size()]);
        }
        if (type.isAssignableFrom(File.class)) {
            return this.getSingleFile();
        }
        if (type.isAssignableFrom(FileCollection.class)) {
            return this;
        }
        if (type.isAssignableFrom(FileTree.class)) {
            return this.getAsFileTree();
        }
        throw new UnsupportedOperationException(String.format("Cannot convert %s to type %s, as this type is not supported.", this.getDisplayName(), type.getSimpleName()));
    }

    @Override
    public TaskDependency getBuildDependencies() {
        return new DefaultTaskDependency();
    }

    @Override
    public FileTree getAsFileTree() {
        return new CompositeFileTree(){

            public void resolve(FileCollectionResolveContext context) {
                ResolvableFileCollectionResolveContext nested = context.newContext();
                nested.add(AbstractFileCollection.this);
                context.add(nested.resolveAsFileTrees());
            }

            public String getDisplayName() {
                return AbstractFileCollection.this.getDisplayName();
            }
        };
    }

    @Override
    public FileCollection filter(Closure filterClosure) {
        return this.filter(Specs.convertClosureToSpec(filterClosure));
    }

    @Override
    public FileCollection filter(final Spec<? super File> filterSpec) {
        return new AbstractFileCollection(){

            @Override
            public String getDisplayName() {
                return AbstractFileCollection.this.getDisplayName();
            }

            @Override
            public TaskDependency getBuildDependencies() {
                return AbstractFileCollection.this.getBuildDependencies();
            }

            @Override
            public Set<File> getFiles() {
                return Specs.filterIterable(AbstractFileCollection.this, filterSpec);
            }
        };
    }

    protected String getCapDisplayName() {
        return StringUtils.capitalize((String)this.getDisplayName());
    }
}

