/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection;

import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.TaskExecution;
import org.gradle.api.internal.changedetection.UpToDateRule;

public class TaskTypeChangedUpToDateRule
implements UpToDateRule {
    public UpToDateRule.TaskUpToDateState create(final TaskInternal task, final TaskExecution previousExecution, TaskExecution currentExecution) {
        final String taskClass = task.getClass().getName();
        currentExecution.setTaskClass(taskClass);
        return new UpToDateRule.TaskUpToDateState(){

            @Override
            public void checkUpToDate(Collection<String> messages) {
                if (!taskClass.equals(previousExecution.getTaskClass())) {
                    messages.add(String.format("%s has changed type from '%s' to '%s'.", StringUtils.capitalize((String)task.toString()), previousExecution.getTaskClass(), task.getClass().getName()));
                }
            }

            @Override
            public void snapshotAfterTask() {
            }
        };
    }
}

