/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection;

import org.gradle.api.internal.TaskExecutionHistory;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.changedetection.FileCacheListener;
import org.gradle.api.internal.changedetection.TaskArtifactState;
import org.gradle.api.internal.changedetection.TaskArtifactStateRepository;

public class FileCacheBroadcastTaskArtifactStateRepository
implements TaskArtifactStateRepository {
    private final TaskArtifactStateRepository repository;
    private final FileCacheListener listener;

    public FileCacheBroadcastTaskArtifactStateRepository(TaskArtifactStateRepository repository, FileCacheListener listener) {
        this.repository = repository;
        this.listener = listener;
    }

    public TaskArtifactState getStateFor(final TaskInternal task) {
        final TaskArtifactState state = this.repository.getStateFor(task);
        return new TaskArtifactState(){

            public boolean isUpToDate() {
                FileCacheBroadcastTaskArtifactStateRepository.this.listener.cacheable(task.getInputs().getFiles());
                FileCacheBroadcastTaskArtifactStateRepository.this.listener.cacheable(task.getOutputs().getFiles());
                return state.isUpToDate();
            }

            public void beforeTask() {
                if (task.getOutputs().getHasOutput()) {
                    FileCacheBroadcastTaskArtifactStateRepository.this.listener.invalidate(task.getOutputs().getFiles());
                } else {
                    FileCacheBroadcastTaskArtifactStateRepository.this.listener.invalidateAll();
                }
                state.beforeTask();
            }

            public void afterTask() {
                FileCacheBroadcastTaskArtifactStateRepository.this.listener.cacheable(task.getOutputs().getFiles());
                state.afterTask();
            }

            public void finished() {
                state.finished();
            }

            public TaskExecutionHistory getExecutionHistory() {
                return state.getExecutionHistory();
            }
        };
    }
}

