/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection;

import java.util.List;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.changedetection.FileCacheListener;
import org.gradle.api.internal.file.collections.DefaultFileCollectionResolveContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFileCacheListener
implements FileCacheListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultFileCacheListener.class);

    public void cacheable(FileCollection files) {
        List<FileCollection> collections = new DefaultFileCollectionResolveContext().add(files).resolveAsFileCollections();
        for (FileCollection collection : collections) {
            LOGGER.debug("Can cache files for {}", (Object)collection);
        }
    }

    public void invalidate(FileCollection files) {
        List<FileCollection> collections = new DefaultFileCollectionResolveContext().add(files).resolveAsFileCollections();
        for (FileCollection collection : collections) {
            LOGGER.debug("Invalidate cached files for {}", (Object)collection);
        }
    }

    public void invalidateAll() {
        LOGGER.debug("Invalidate all cached files");
    }
}

