/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection;

import org.gradle.api.internal.changedetection.FileCollectionSnapshot;
import org.gradle.api.internal.changedetection.FileSnapshotRepository;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.PersistentIndexedCache;

public class CacheBackedFileSnapshotRepository
implements FileSnapshotRepository {
    private final CacheRepository repository;
    private PersistentIndexedCache<Object, Object> cache;

    public CacheBackedFileSnapshotRepository(CacheRepository repository) {
        this.repository = repository;
    }

    public Long add(FileCollectionSnapshot snapshot) {
        this.open();
        Long id = (Long)this.cache.get("nextId");
        if (id == null) {
            id = 1L;
        }
        this.cache.put("nextId", id + 1L);
        this.cache.put(id, snapshot);
        return id;
    }

    public FileCollectionSnapshot get(Long id) {
        this.open();
        return (FileCollectionSnapshot)this.cache.get(id);
    }

    public void remove(Long id) {
        this.open();
        this.cache.remove(id);
    }

    private void open() {
        if (this.cache == null) {
            this.cache = this.repository.cache("fileSnapshots").open().openIndexedCache();
        }
    }
}

