/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.repositories;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.cache.ArtifactOrigin;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DependencyArtifactDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.DownloadReport;
import org.apache.ivy.core.report.DownloadStatus;
import org.apache.ivy.core.report.MetadataArtifactDownloadReport;
import org.apache.ivy.core.resolve.DownloadOptions;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.repository.file.FileRepository;
import org.apache.ivy.plugins.repository.file.FileResource;
import org.apache.ivy.plugins.resolver.BasicResolver;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.plugins.resolver.util.ResolvedResource;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Module;
import org.gradle.api.internal.artifacts.ivyservice.ModuleDescriptorConverter;
import org.gradle.api.internal.artifacts.ivyservice.NoOpRepositoryCacheManager;
import org.gradle.api.internal.artifacts.repositories.InternalRepository;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.invocation.Gradle;
import org.gradle.util.ReflectionUtil;

public class DefaultInternalRepository
extends BasicResolver
implements InternalRepository {
    private final ModuleDescriptorConverter moduleDescriptorConverter;
    private final Gradle gradle;

    public DefaultInternalRepository(Gradle gradle, ModuleDescriptorConverter moduleDescriptorConverter) {
        this.gradle = gradle;
        this.moduleDescriptorConverter = moduleDescriptorConverter;
        this.setName("internal-repository");
        this.setRepositoryCacheManager(new NoOpRepositoryCacheManager(this.getName()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResolvedModuleRevision getDependency(DependencyDescriptor dd, ResolveData data) throws ParseException {
        ModuleDescriptor moduleDescriptor = this.findProject(dd);
        if (moduleDescriptor == null) {
            return data.getCurrentResolvedModuleRevision();
        }
        IvyContext context = IvyContext.pushNewCopyContext();
        try {
            context.setDependencyDescriptor(dd);
            context.setResolveData(data);
            MetadataArtifactDownloadReport downloadReport = new MetadataArtifactDownloadReport(moduleDescriptor.getMetadataArtifact());
            downloadReport.setDownloadStatus(DownloadStatus.NO);
            downloadReport.setSearched(false);
            ResolvedModuleRevision resolvedModuleRevision = new ResolvedModuleRevision((DependencyResolver)this, (DependencyResolver)this, moduleDescriptor, downloadReport);
            return resolvedModuleRevision;
        }
        finally {
            IvyContext.popContext();
        }
    }

    private ModuleDescriptor findProject(DependencyDescriptor descriptor) {
        String projectPathValue = descriptor.getAttribute("org.gradle.projectPath");
        if (projectPathValue == null) {
            return null;
        }
        Project project = this.gradle.getRootProject().project(projectPathValue);
        Module projectModule = ((ProjectInternal)project).getModule();
        ModuleDescriptor projectDescriptor = this.moduleDescriptorConverter.convert(project.getConfigurations().getAll(), projectModule, IvyContext.getContext().getIvy().getSettings());
        for (DependencyArtifactDescriptor artifactDescriptor : descriptor.getAllDependencyArtifacts()) {
            for (Artifact artifact : projectDescriptor.getAllArtifacts()) {
                if (!artifact.getName().equals(artifactDescriptor.getName()) || !artifact.getExt().equals(artifactDescriptor.getExt())) continue;
                String path = artifact.getExtraAttribute("filePath");
                ReflectionUtil.invoke(artifactDescriptor, "setExtraAttribute", "filePath", path);
            }
        }
        return projectDescriptor;
    }

    protected ResolvedResource findArtifactRef(Artifact artifact, Date date) {
        String path = artifact.getExtraAttribute("filePath");
        if (path == null) {
            return null;
        }
        File file = new File(path);
        return new ResolvedResource((Resource)new FileResource(new FileRepository(), file), artifact.getId().getRevision());
    }

    public DownloadReport download(Artifact[] artifacts, DownloadOptions options) {
        DownloadReport dr = new DownloadReport();
        for (Artifact artifact : artifacts) {
            ArtifactDownloadReport artifactDownloadReport = new ArtifactDownloadReport(artifact);
            String path = artifact.getExtraAttribute("filePath");
            if (path == null) {
                artifactDownloadReport.setDownloadStatus(DownloadStatus.FAILED);
            } else {
                File file = new File(path);
                artifactDownloadReport.setDownloadStatus(DownloadStatus.SUCCESSFUL);
                artifactDownloadReport.setArtifactOrigin(new ArtifactOrigin(artifact, true, this.getName()));
                artifactDownloadReport.setLocalFile(file);
                artifactDownloadReport.setSize(file.length());
            }
            dr.addArtifactReport(artifactDownloadReport);
        }
        return dr;
    }

    protected Resource getResource(String source) throws IOException {
        return null;
    }

    protected Collection findNames(Map tokenValues, String token) {
        return null;
    }

    protected long get(Resource resource, File dest) throws IOException {
        return 0L;
    }

    public ResolvedResource findIvyFileRef(DependencyDescriptor dd, ResolveData data) {
        return null;
    }

    public void publish(Artifact artifact, File src, boolean overwrite) throws IOException {
    }
}

