/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies;

import java.util.Set;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.plugins.conflict.ConflictManager;
import org.apache.ivy.plugins.conflict.LatestConflictManager;
import org.apache.ivy.plugins.latest.LatestRevisionStrategy;
import org.apache.ivy.plugins.latest.LatestStrategy;
import org.apache.ivy.plugins.matcher.ExactPatternMatcher;
import org.apache.ivy.plugins.matcher.PatternMatcher;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ExcludeRule;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.ExcludeRuleConverter;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.DependenciesToModuleDescriptorConverter;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.DependencyDescriptorFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDependenciesToModuleDescriptorConverter
implements DependenciesToModuleDescriptorConverter {
    private DependencyDescriptorFactory dependencyDescriptorFactory;
    private ExcludeRuleConverter excludeRuleConverter;

    public DefaultDependenciesToModuleDescriptorConverter(DependencyDescriptorFactory dependencyDescriptorFactory, ExcludeRuleConverter excludeRuleConverter) {
        this.dependencyDescriptorFactory = dependencyDescriptorFactory;
        this.excludeRuleConverter = excludeRuleConverter;
    }

    @Override
    public void addDependencyDescriptors(DefaultModuleDescriptor moduleDescriptor, Set<Configuration> configurations, IvySettings ivySettings) {
        assert (!configurations.isEmpty());
        this.addDependencies(moduleDescriptor, configurations);
        this.addExcludeRules(moduleDescriptor, configurations);
        this.addConflictManager(moduleDescriptor, ivySettings);
    }

    private void addDependencies(DefaultModuleDescriptor moduleDescriptor, Set<Configuration> configurations) {
        for (Configuration configuration : configurations) {
            for (ModuleDependency dependency : configuration.getDependencies(ModuleDependency.class)) {
                this.dependencyDescriptorFactory.addDependencyDescriptor(configuration.getName(), moduleDescriptor, dependency);
            }
        }
    }

    private void addExcludeRules(DefaultModuleDescriptor moduleDescriptor, Set<Configuration> configurations) {
        for (Configuration configuration : configurations) {
            for (ExcludeRule excludeRule : configuration.getExcludeRules()) {
                org.apache.ivy.core.module.descriptor.ExcludeRule rule = this.excludeRuleConverter.createExcludeRule(configuration.getName(), excludeRule);
                moduleDescriptor.addExcludeRule(rule);
            }
        }
    }

    private void addConflictManager(DefaultModuleDescriptor moduleDescriptor, IvySettings ivySettings) {
        LatestConflictManager conflictManager = new LatestConflictManager((LatestStrategy)new LatestRevisionStrategy());
        conflictManager.setSettings(ivySettings);
        moduleDescriptor.addConflictManager(new ModuleId("*", "*"), (PatternMatcher)ExactPatternMatcher.INSTANCE, (ConflictManager)conflictManager);
    }

    public DependencyDescriptorFactory getDependencyDescriptorFactory() {
        return this.dependencyDescriptorFactory;
    }

    public void setDependencyDescriptorFactory(DependencyDescriptorFactory dependencyDescriptorFactory) {
        this.dependencyDescriptorFactory = dependencyDescriptorFactory;
    }

    public ExcludeRuleConverter getExcludeRuleConverter() {
        return this.excludeRuleConverter;
    }

    public void setExcludeRuleConverter(ExcludeRuleConverter excludeRuleConverter) {
        this.excludeRuleConverter = excludeRuleConverter;
    }
}

