/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.ivy.core.module.descriptor.DefaultDependencyArtifactDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyArtifactDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.DependencyArtifact;
import org.gradle.api.artifacts.ExcludeRule;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.ExcludeRuleConverter;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.DependencyDescriptorFactoryInternal;
import org.gradle.util.WrapUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDependencyDescriptorFactoryInternal
implements DependencyDescriptorFactoryInternal {
    private ExcludeRuleConverter excludeRuleConverter;

    public AbstractDependencyDescriptorFactoryInternal(ExcludeRuleConverter excludeRuleConverter) {
        this.excludeRuleConverter = excludeRuleConverter;
    }

    @Override
    public void addDependencyDescriptor(String configuration, DefaultModuleDescriptor moduleDescriptor, ModuleDependency dependency) {
        ModuleRevisionId moduleRevisionId = this.createModuleRevisionId(dependency);
        DependencyDescriptor newDescriptor = this.createDependencyDescriptor(dependency, configuration, (ModuleDescriptor)moduleDescriptor, moduleRevisionId);
        DefaultDependencyDescriptor existingDependencyDescriptor = this.findExistingDescriptor(moduleDescriptor, newDescriptor);
        if (existingDependencyDescriptor == null) {
            moduleDescriptor.addDependency(newDescriptor);
        } else {
            existingDependencyDescriptor.addDependencyConfiguration(configuration, dependency.getConfiguration());
        }
    }

    protected abstract DependencyDescriptor createDependencyDescriptor(ModuleDependency var1, String var2, ModuleDescriptor var3, ModuleRevisionId var4);

    private DefaultDependencyDescriptor findExistingDescriptor(DefaultModuleDescriptor moduleDescriptor, DependencyDescriptor targetDescriptor) {
        for (DependencyDescriptor dependencyDescriptor : moduleDescriptor.getDependencies()) {
            HashSet<DependencyArtifactDescriptor> targetDependencies;
            HashSet<DependencyArtifactDescriptor> nextDependencies;
            if (!dependencyDescriptor.getDependencyRevisionId().equals((Object)targetDescriptor.getDependencyRevisionId()) || !(nextDependencies = new HashSet<DependencyArtifactDescriptor>(Arrays.asList(dependencyDescriptor.getAllDependencyArtifacts()))).equals(targetDependencies = new HashSet<DependencyArtifactDescriptor>(Arrays.asList(targetDescriptor.getAllDependencyArtifacts())))) continue;
            return (DefaultDependencyDescriptor)dependencyDescriptor;
        }
        return null;
    }

    protected void addExcludesArtifactsAndDependencies(String configuration, ModuleDependency dependency, DefaultDependencyDescriptor dependencyDescriptor) {
        this.addArtifacts(configuration, dependency.getArtifacts(), dependencyDescriptor);
        this.addExcludes(configuration, dependency.getExcludeRules(), dependencyDescriptor);
        this.addDependencyConfiguration(configuration, dependency, dependencyDescriptor);
    }

    private void addArtifacts(String configuration, Set<DependencyArtifact> artifacts, DefaultDependencyDescriptor dependencyDescriptor) {
        for (DependencyArtifact artifact : artifacts) {
            DefaultDependencyArtifactDescriptor artifactDescriptor;
            try {
                artifactDescriptor = new DefaultDependencyArtifactDescriptor((DependencyDescriptor)dependencyDescriptor, artifact.getName(), artifact.getType(), artifact.getExtension() != null ? artifact.getExtension() : artifact.getType(), artifact.getUrl() != null ? new URL(artifact.getUrl()) : null, artifact.getClassifier() != null ? WrapUtil.toMap("m:classifier", artifact.getClassifier()) : null);
            }
            catch (MalformedURLException e) {
                throw new InvalidUserDataException("URL for artifact can't be parsed: " + artifact.getUrl(), e);
            }
            dependencyDescriptor.addDependencyArtifact(configuration, (DependencyArtifactDescriptor)artifactDescriptor);
        }
    }

    private void addDependencyConfiguration(String configuration, ModuleDependency dependency, DefaultDependencyDescriptor dependencyDescriptor) {
        dependencyDescriptor.addDependencyConfiguration(configuration, dependency.getConfiguration());
    }

    private void addExcludes(String configuration, Set<ExcludeRule> excludeRules, DefaultDependencyDescriptor dependencyDescriptor) {
        for (ExcludeRule excludeRule : excludeRules) {
            dependencyDescriptor.addExcludeRule(configuration, this.excludeRuleConverter.createExcludeRule(configuration, excludeRule));
        }
    }

    public ExcludeRuleConverter getExcludeRuleConverter() {
        return this.excludeRuleConverter;
    }

    public void setExcludeRuleConverter(ExcludeRuleConverter excludeRuleConverter) {
        this.excludeRuleConverter = excludeRuleConverter;
    }
}

